/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import io.fury.annotation.Internal;
import io.fury.codegen.CodegenContext;
import io.fury.codegen.Expression;
import io.fury.codegen.ExpressionOptimizer;
import io.fury.collection.Tuple3;
import io.fury.type.Descriptor;
import io.fury.type.DescriptorGrouper;
import io.fury.util.function.SerializableSupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@Internal
public class ObjectCodecOptimizer
extends ExpressionOptimizer {
    private final Class<?> cls;
    private final boolean boxedRefTracking;
    private final CodegenContext ctx;
    final DescriptorGrouper descriptorGrouper;
    final List<List<Descriptor>> primitiveGroups = new ArrayList<List<Descriptor>>();
    final List<List<Descriptor>> boxedWriteGroups = new ArrayList<List<Descriptor>>();
    final List<List<Descriptor>> boxedReadGroups = new ArrayList<List<Descriptor>>();
    final List<List<Descriptor>> finalWriteGroups = new ArrayList<List<Descriptor>>();
    final List<List<Descriptor>> finalReadGroups = new ArrayList<List<Descriptor>>();
    final List<List<Descriptor>> otherWriteGroups = new ArrayList<List<Descriptor>>();
    final List<List<Descriptor>> otherReadGroups = new ArrayList<List<Descriptor>>();

    ObjectCodecOptimizer(Class<?> cls, DescriptorGrouper descriptorGrouper, boolean boxedRefTracking, CodegenContext ctx) {
        this.cls = cls;
        this.descriptorGrouper = descriptorGrouper;
        this.boxedRefTracking = boxedRefTracking;
        this.ctx = ctx;
        this.buildGroups();
    }

    private void buildGroups() {
        List<Descriptor> primitiveDescriptorsList = new ArrayList<Descriptor>(this.descriptorGrouper.getPrimitiveDescriptors());
        while (primitiveDescriptorsList.size() > 0) {
            int endIndex = Math.min(24, primitiveDescriptorsList.size());
            this.primitiveGroups.add(primitiveDescriptorsList.subList(0, endIndex));
            primitiveDescriptorsList = primitiveDescriptorsList.subList(endIndex, primitiveDescriptorsList.size());
        }
        int boxedWriteWeight = 7;
        int boxedReadWeight = 7;
        if (this.boxedRefTracking) {
            boxedReadWeight = 4;
        }
        List<Tuple3> groups = Arrays.asList(Tuple3.of(new ArrayList<Descriptor>(this.descriptorGrouper.getBoxedDescriptors()), boxedWriteWeight, this.boxedWriteGroups), Tuple3.of(new ArrayList<Descriptor>(this.descriptorGrouper.getBoxedDescriptors()), boxedReadWeight, this.boxedReadGroups), Tuple3.of(new ArrayList<Descriptor>(this.descriptorGrouper.getFinalDescriptors()), 9, this.finalWriteGroups), Tuple3.of(new ArrayList<Descriptor>(this.descriptorGrouper.getFinalDescriptors()), 5, this.finalReadGroups), Tuple3.of(new ArrayList<Descriptor>(this.descriptorGrouper.getOtherDescriptors()), 5, this.otherReadGroups), Tuple3.of(new ArrayList<Descriptor>(this.descriptorGrouper.getOtherDescriptors()), 9, this.otherWriteGroups));
        for (Tuple3 decs : groups) {
            while (((List)decs.f0).size() > 0) {
                int endIndex = Math.min((Integer)decs.f1, ((List)decs.f0).size());
                ((List)decs.f2).add(((List)decs.f0).subList(0, endIndex));
                decs.f0 = ((List)decs.f0).subList(endIndex, ((List)decs.f0).size());
            }
        }
    }

    Expression invokeGenerated(SerializableSupplier<Expression> groupExpressionsGenerator, String methodPrefix) {
        return ObjectCodecOptimizer.invokeGenerated(this.ctx, groupExpressionsGenerator, methodPrefix);
    }

    Expression invokeGenerated(Set<Expression> cutPoint, Expression groupExpressions, String methodPrefix) {
        return ObjectCodecOptimizer.invokeGenerated(this.ctx, cutPoint, groupExpressions, methodPrefix, false);
    }
}

