/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.DataStreamLifecycleDownsampling;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamLifecycle
implements JsonpSerializable {
    @Nullable
    private final Time dataRetention;
    @Nullable
    private final DataStreamLifecycleDownsampling downsampling;
    public static final JsonpDeserializer<DataStreamLifecycle> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamLifecycle::setupDataStreamLifecycleDeserializer);

    private DataStreamLifecycle(Builder builder) {
        this.dataRetention = builder.dataRetention;
        this.downsampling = builder.downsampling;
    }

    public static DataStreamLifecycle of(Function<Builder, ObjectBuilder<DataStreamLifecycle>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time dataRetention() {
        return this.dataRetention;
    }

    @Nullable
    public final DataStreamLifecycleDownsampling downsampling() {
        return this.downsampling;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dataRetention != null) {
            generator.writeKey("data_retention");
            this.dataRetention.serialize(generator, mapper);
        }
        if (this.downsampling != null) {
            generator.writeKey("downsampling");
            this.downsampling.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamLifecycleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataRetention, Time._DESERIALIZER, "data_retention");
        op.add(Builder::downsampling, DataStreamLifecycleDownsampling._DESERIALIZER, "downsampling");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamLifecycle> {
        @Nullable
        private Time dataRetention;
        @Nullable
        private DataStreamLifecycleDownsampling downsampling;

        public final Builder dataRetention(@Nullable Time value) {
            this.dataRetention = value;
            return this;
        }

        public final Builder dataRetention(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.dataRetention(fn.apply(new Time.Builder()).build());
        }

        public final Builder downsampling(@Nullable DataStreamLifecycleDownsampling value) {
            this.downsampling = value;
            return this;
        }

        public final Builder downsampling(Function<DataStreamLifecycleDownsampling.Builder, ObjectBuilder<DataStreamLifecycleDownsampling>> fn) {
            return this.downsampling(fn.apply(new DataStreamLifecycleDownsampling.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamLifecycle build() {
            this._checkSingleUse();
            return new DataStreamLifecycle(this);
        }
    }
}

