/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceConfigCreate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigCreateVariant;
import co.elastic.clients.elasticsearch.ml.TokenizationConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QuestionAnsweringInferenceOptions
implements InferenceConfigCreateVariant,
JsonpSerializable {
    @Nullable
    private final Integer numTopClasses;
    @Nullable
    private final TokenizationConfig tokenization;
    @Nullable
    private final String resultsField;
    @Nullable
    private final Integer maxAnswerLength;
    public static final JsonpDeserializer<QuestionAnsweringInferenceOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QuestionAnsweringInferenceOptions::setupQuestionAnsweringInferenceOptionsDeserializer);

    private QuestionAnsweringInferenceOptions(Builder builder) {
        this.numTopClasses = builder.numTopClasses;
        this.tokenization = builder.tokenization;
        this.resultsField = builder.resultsField;
        this.maxAnswerLength = builder.maxAnswerLength;
    }

    public static QuestionAnsweringInferenceOptions of(Function<Builder, ObjectBuilder<QuestionAnsweringInferenceOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfigCreate.Kind _inferenceConfigCreateKind() {
        return InferenceConfigCreate.Kind.QuestionAnswering;
    }

    @Nullable
    public final Integer numTopClasses() {
        return this.numTopClasses;
    }

    @Nullable
    public final TokenizationConfig tokenization() {
        return this.tokenization;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    @Nullable
    public final Integer maxAnswerLength() {
        return this.maxAnswerLength;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numTopClasses != null) {
            generator.writeKey("num_top_classes");
            generator.write(this.numTopClasses.intValue());
        }
        if (this.tokenization != null) {
            generator.writeKey("tokenization");
            this.tokenization.serialize(generator, mapper);
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (this.maxAnswerLength != null) {
            generator.writeKey("max_answer_length");
            generator.write(this.maxAnswerLength.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupQuestionAnsweringInferenceOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numTopClasses, JsonpDeserializer.integerDeserializer(), "num_top_classes");
        op.add(Builder::tokenization, TokenizationConfig._DESERIALIZER, "tokenization");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
        op.add(Builder::maxAnswerLength, JsonpDeserializer.integerDeserializer(), "max_answer_length");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QuestionAnsweringInferenceOptions> {
        @Nullable
        private Integer numTopClasses;
        @Nullable
        private TokenizationConfig tokenization;
        @Nullable
        private String resultsField;
        @Nullable
        private Integer maxAnswerLength;

        public final Builder numTopClasses(@Nullable Integer value) {
            this.numTopClasses = value;
            return this;
        }

        public final Builder tokenization(@Nullable TokenizationConfig value) {
            this.tokenization = value;
            return this;
        }

        public final Builder tokenization(Function<TokenizationConfig.Builder, ObjectBuilder<TokenizationConfig>> fn) {
            return this.tokenization(fn.apply(new TokenizationConfig.Builder()).build());
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public final Builder maxAnswerLength(@Nullable Integer value) {
            this.maxAnswerLength = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QuestionAnsweringInferenceOptions build() {
            this._checkSingleUse();
            return new QuestionAnsweringInferenceOptions(this);
        }
    }
}

