/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javafx.concurrent.Task;
import org.apache.sis.gui.coverage.GridError;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.gui.coverage.GridViewSkin;
import org.apache.sis.gui.internal.BackgroundThreads;

final class GridTile {
    final int tileX;
    final int tileY;
    private Raster tile;
    private GridError error;
    private boolean loading;

    GridTile(int tileX, int tileY) {
        this.tileX = tileX;
        this.tileY = tileY;
    }

    public int hashCode() {
        return this.tileX ^ Integer.reverse(this.tileY);
    }

    public boolean equals(Object other) {
        if (other instanceof GridTile) {
            GridTile that = (GridTile)other;
            return this.tileX == that.tileX && this.tileY == that.tileY;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[" + this.tileX + ", " + this.tileY + "]";
    }

    final Raster tile() {
        return this.tile;
    }

    final boolean clearTile() {
        if (this.loading) {
            return false;
        }
        this.tile = null;
        return this.error == null;
    }

    final void clear() {
        this.tile = null;
        this.error = null;
        this.loading = false;
    }

    final void load(final GridView view) {
        if (!this.loading && this.error == null) {
            this.loading = true;
            final RenderedImage image = view.getImage();
            BackgroundThreads.execute((Runnable)new Task<Raster>(this){
                final /* synthetic */ GridTile this$0;
                {
                    this.this$0 = this$0;
                }

                protected Raster call() {
                    return image.getTile(this.this$0.tileX, this.this$0.tileY);
                }

                protected void succeeded() {
                    this.this$0.clear();
                    if (view.getImage() == image) {
                        this.this$0.tile = (Raster)this.getValue();
                        view.updateCellValues();
                    }
                }

                protected void failed() {
                    this.this$0.clear();
                    if (view.getImage() == image) {
                        this.this$0.error = new GridError(view, this.this$0, this.getException());
                        ((GridViewSkin)view.getSkin()).errorOccurred(this.this$0.error);
                    }
                }

                protected void cancelled() {
                    this.this$0.clear();
                }
            });
        }
    }
}

