/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class Arguments {
    String title = "Flame Graph";
    String highlight;
    String state;
    Pattern include;
    Pattern exclude;
    double minwidth;
    int skip;
    boolean reverse;
    boolean alloc;
    boolean live;
    boolean lock;
    boolean threads;
    boolean classify;
    boolean total;
    boolean lines;
    boolean bci;
    boolean simple;
    boolean dot;
    boolean norm;
    boolean collapsed;
    long from;
    long to;
    String input;
    String output;

    public Arguments(String ... args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("--")) {
                try {
                    Field f = Arguments.class.getDeclaredField(arg.substring(2));
                    if ((f.getModifiers() & 0x1A) != 0) {
                        throw new IllegalStateException(arg);
                    }
                    Class<?> type = f.getType();
                    if (type == String.class) {
                        f.set(this, args[++i]);
                        continue;
                    }
                    if (type == Boolean.TYPE) {
                        f.setBoolean(this, true);
                        continue;
                    }
                    if (type == Integer.TYPE) {
                        f.setInt(this, Integer.parseInt(args[++i]));
                        continue;
                    }
                    if (type == Double.TYPE) {
                        f.setDouble(this, Double.parseDouble(args[++i]));
                        continue;
                    }
                    if (type == Long.TYPE) {
                        f.setLong(this, this.parseTimestamp(args[++i]));
                        continue;
                    }
                    if (type != Pattern.class) continue;
                    f.set(this, Pattern.compile(args[++i]));
                    continue;
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IllegalArgumentException(arg);
                }
            }
            if (arg.isEmpty()) continue;
            if (this.input == null) {
                this.input = arg;
                continue;
            }
            this.output = arg;
        }
    }

    private long parseTimestamp(String time) {
        if (time.indexOf(58) < 0) {
            return Long.parseLong(time);
        }
        GregorianCalendar cal = new GregorianCalendar();
        StringTokenizer st = new StringTokenizer(time, "-:.T");
        if (time.indexOf(84) > 0) {
            cal.set(1, Integer.parseInt(st.nextToken()));
            cal.set(2, Integer.parseInt(st.nextToken()) - 1);
            cal.set(5, Integer.parseInt(st.nextToken()));
        }
        cal.set(11, st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0);
        cal.set(12, st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0);
        cal.set(13, st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0);
        cal.set(14, st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0);
        return cal.getTimeInMillis();
    }
}

