/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.AbstractRequestContextBuilder;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.ClientConnectionTimings;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.client.DefaultClientRequestContext;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoop;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Objects;
import javax.net.ssl.SSLSession;

public final class ClientRequestContextBuilder
extends AbstractRequestContextBuilder {
    @Nullable
    private EndpointGroup endpointGroup;
    private ClientOptions options = ClientOptions.of();
    private RequestOptions requestOptions = RequestOptions.of();
    @Nullable
    private ClientConnectionTimings connectionTimings;

    ClientRequestContextBuilder(HttpRequest request) {
        super(false, request);
    }

    ClientRequestContextBuilder(RpcRequest request, URI uri) {
        super(false, request, uri);
    }

    @Override
    public ClientRequestContextBuilder method(HttpMethod method) {
        super.method(method);
        return this;
    }

    @Deprecated
    public ClientRequestContextBuilder endpoint(Endpoint endpoint) {
        return this.endpointGroup(endpoint);
    }

    public ClientRequestContextBuilder endpointGroup(EndpointGroup endpointGroup) {
        this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
        return this;
    }

    public ClientRequestContextBuilder options(ClientOptions options) {
        this.options = Objects.requireNonNull(options, "options");
        return this;
    }

    public ClientRequestContextBuilder connectionTimings(ClientConnectionTimings connectionTimings) {
        this.connectionTimings = Objects.requireNonNull(connectionTimings, "connectionTimings");
        return this;
    }

    public ClientRequestContextBuilder requestOptions(RequestOptions requestOptions) {
        this.requestOptions = Objects.requireNonNull(requestOptions, "requestOptions");
        return this;
    }

    public ClientRequestContext build() {
        EndpointGroup endpointGroup = this.endpointGroup != null ? this.endpointGroup : Endpoint.parse(this.authority());
        DefaultClientRequestContext ctx = new DefaultClientRequestContext(this.eventLoop(), this.meterRegistry(), this.sessionProtocol(), this.id(), this.method(), this.requestTarget(), endpointGroup, this.options, this.request(), this.rpcRequest(), this.requestOptions, CancellationScheduler.ofClient(0L), this.isRequestStartTimeSet() ? this.requestStartTimeNanos() : System.nanoTime(), this.isRequestStartTimeSet() ? this.requestStartTimeMicros() : SystemInfo.currentTimeMicros());
        if (this.timedOut()) {
            ctx.timeoutNow();
        }
        ctx.init().handle((unused, cause) -> {
            ctx.finishInitialization(cause == null);
            return null;
        });
        ctx.logBuilder().session(this.fakeChannel(ctx.eventLoop()), this.sessionProtocol(), this.sslSession(), this.connectionTimings);
        if (this.request() != null) {
            ctx.logBuilder().requestHeaders(this.request().headers());
        }
        if (this.rpcRequest() != null) {
            ctx.logBuilder().requestContent(this.rpcRequest(), null);
        }
        return ctx;
    }

    @Override
    public ClientRequestContextBuilder meterRegistry(MeterRegistry meterRegistry) {
        return (ClientRequestContextBuilder)super.meterRegistry(meterRegistry);
    }

    @Override
    public ClientRequestContextBuilder eventLoop(EventLoop eventLoop) {
        return (ClientRequestContextBuilder)super.eventLoop(eventLoop);
    }

    @Override
    public ClientRequestContextBuilder alloc(ByteBufAllocator alloc) {
        return (ClientRequestContextBuilder)super.alloc(alloc);
    }

    @Override
    public ClientRequestContextBuilder sessionProtocol(SessionProtocol sessionProtocol) {
        return (ClientRequestContextBuilder)super.sessionProtocol(sessionProtocol);
    }

    @Override
    public ClientRequestContextBuilder id(RequestId id) {
        return (ClientRequestContextBuilder)super.id(id);
    }

    @Override
    public ClientRequestContextBuilder remoteAddress(InetSocketAddress remoteAddress) {
        return (ClientRequestContextBuilder)super.remoteAddress(remoteAddress);
    }

    @Override
    public ClientRequestContextBuilder localAddress(InetSocketAddress localAddress) {
        return (ClientRequestContextBuilder)super.localAddress(localAddress);
    }

    @Override
    public ClientRequestContextBuilder sslSession(SSLSession sslSession) {
        return (ClientRequestContextBuilder)super.sslSession(sslSession);
    }

    @Override
    public ClientRequestContextBuilder requestStartTime(long requestStartTimeNanos, long requestStartTimeMicros) {
        return (ClientRequestContextBuilder)super.requestStartTime(requestStartTimeNanos, requestStartTimeMicros);
    }

    @Override
    public ClientRequestContextBuilder timedOut(boolean timedOut) {
        return (ClientRequestContextBuilder)super.timedOut(timedOut);
    }
}

