/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.encoding;

import com.linecorp.armeria.common.encoding.AbstractStreamDecoder;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.compression.JZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.internal.SystemPropertyUtil;

final class ZlibStreamDecoder
extends AbstractStreamDecoder {
    private static final boolean noJdkZlibDecoder = SystemPropertyUtil.getBoolean("io.netty.noJdkZlibDecoder", false);

    ZlibStreamDecoder(ZlibWrapper zlibWrapper, ByteBufAllocator alloc, int maxLength) {
        super(ZlibStreamDecoder.newZlibDecoder(zlibWrapper, maxLength), alloc, maxLength);
    }

    private static ZlibDecoder newZlibDecoder(ZlibWrapper wrapper, int maxLength) {
        if (noJdkZlibDecoder) {
            return new JZlibDecoder(wrapper, maxLength);
        }
        return new JdkZlibDecoder(wrapper, true, maxLength);
    }
}

