/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.webapp;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientBuilder;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroupBuilder;
import com.linecorp.armeria.client.logging.LoggingClient;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class OapProxyService
extends AbstractHttpService {
    private final WebClient loadBalancingClient;

    public OapProxyService(String[] oapServices) throws Exception {
        List endpoints = Stream.of(oapServices).map(URI::create).map(URI::getAuthority).map(Endpoint::parse).collect(Collectors.toList());
        this.loadBalancingClient = OapProxyService.newLoadBalancingClient(EndpointGroup.of(EndpointSelectionStrategy.roundRobin(), endpoints));
    }

    private static WebClient newLoadBalancingClient(EndpointGroup oapGroup) {
        HealthCheckedEndpointGroup healthCheckedGroup = ((HealthCheckedEndpointGroupBuilder)((HealthCheckedEndpointGroupBuilder)HealthCheckedEndpointGroup.builder(oapGroup, "/healthcheck").protocol(SessionProtocol.HTTP)).retryInterval(Duration.ofSeconds(10L))).build();
        healthCheckedGroup.whenReady().get();
        return ((WebClientBuilder)WebClient.builder(SessionProtocol.HTTP, oapGroup).decorator(LoggingClient.newDecorator())).build();
    }

    @Override
    protected HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return this.loadBalancingClient.execute(req);
    }
}

