/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.io.IOException;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public abstract class ManagementCRUDEsDAO
extends EsDAO {
    private final StorageBuilder<ManagementData> storageBuilder;

    public ManagementCRUDEsDAO(ElasticSearchClient client, StorageBuilder<ManagementData> storageBuilder) {
        super(client);
        this.storageBuilder = storageBuilder;
    }

    public boolean create(String modelName, ManagementData managementData) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName(modelName);
        ElasticSearchConverter.ToStorage toStorage = new ElasticSearchConverter.ToStorage(modelName);
        this.storageBuilder.entity2Storage((StorageData)managementData, (Convert2Storage)toStorage);
        String docId = IndexController.INSTANCE.generateDocId(modelName, managementData.id().build());
        boolean exist = ((ElasticSearchClient)this.getClient()).existDoc(index, docId);
        if (exist) {
            return false;
        }
        Map<String, Object> source = IndexController.INSTANCE.appendTableColumn4ManagementData(modelName, (Map<String, Object>)toStorage.obtain());
        ((ElasticSearchClient)this.getClient()).forceInsert(index, docId, source);
        return true;
    }

    public ManagementData getById(String modelName, String id) throws IOException {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName(modelName);
        String docId = IndexController.INSTANCE.generateDocId(modelName, id);
        SearchBuilder search = Search.builder().query((QueryBuilder)Query.ids((String[])new String[]{docId})).size(Integer.valueOf(1));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        if (response.getHits().getHits().size() > 0) {
            SearchHit data = (SearchHit)response.getHits().getHits().get(0);
            return (ManagementData)this.storageBuilder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity(modelName, data.getSource()));
        }
        return null;
    }

    public boolean update(String modelName, ManagementData managementData) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName(modelName);
        ElasticSearchConverter.ToStorage toStorage = new ElasticSearchConverter.ToStorage(modelName);
        this.storageBuilder.entity2Storage((StorageData)managementData, (Convert2Storage)toStorage);
        String docId = IndexController.INSTANCE.generateDocId(modelName, managementData.id().build());
        boolean exist = ((ElasticSearchClient)this.getClient()).existDoc(index, docId);
        if (!exist) {
            return false;
        }
        Map<String, Object> source = IndexController.INSTANCE.appendTableColumn4ManagementData(modelName, (Map<String, Object>)toStorage.obtain());
        ((ElasticSearchClient)this.getClient()).forceUpdate(index, docId, source);
        return true;
    }

    public boolean deleteById(String modelName, String id) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName(modelName);
        String docId = IndexController.INSTANCE.generateDocId(modelName, id);
        boolean exist = ((ElasticSearchClient)this.getClient()).existDoc(index, docId);
        if (!exist) {
            return false;
        }
        ((ElasticSearchClient)this.getClient()).deleteById(index, docId);
        return true;
    }
}

