/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener;

import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppWebVitalsPerf;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.decorators.BrowserWebVitalsPerfDataDecorator;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener.PerfDataAnalysisListener;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener.PerfDataListenerFactory;

public class BrowserWebVitalsPerfDataAnalysisListener
implements PerfDataAnalysisListener<BrowserWebVitalsPerfDataDecorator> {
    private final SourceReceiver sourceReceiver;
    private final NamingControl namingControl;
    private BrowserAppWebVitalsPerf browserAppWebVitalsPerf;

    public BrowserWebVitalsPerfDataAnalysisListener(SourceReceiver sourceReceiver, NamingControl namingControl) {
        this.sourceReceiver = sourceReceiver;
        this.namingControl = namingControl;
    }

    @Override
    public void build() {
        this.sourceReceiver.receive((ISource)this.browserAppWebVitalsPerf);
    }

    @Override
    public void parse(BrowserWebVitalsPerfDataDecorator decorator) {
        this.browserAppWebVitalsPerf = new BrowserAppWebVitalsPerf();
        this.browserAppWebVitalsPerf.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)decorator.getTime()));
        this.browserAppWebVitalsPerf.setServiceName(this.namingControl.formatServiceName(decorator.getService()));
        this.browserAppWebVitalsPerf.setPath(this.namingControl.formatEndpointName(this.browserAppWebVitalsPerf.getServiceName(), decorator.getPagePath()));
        this.browserAppWebVitalsPerf.setFmpTime(decorator.getFmpTime());
        this.browserAppWebVitalsPerf.setClsTime(decorator.getClsTime());
        this.browserAppWebVitalsPerf.setLcpTime(decorator.getLcpTime());
    }

    public static class Factory
    implements PerfDataListenerFactory<BrowserWebVitalsPerfDataDecorator> {
        private final SourceReceiver sourceReceiver;
        private final NamingControl namingControl;

        public Factory(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        }

        @Override
        public PerfDataAnalysisListener<BrowserWebVitalsPerfDataDecorator> create(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            return new BrowserWebVitalsPerfDataAnalysisListener(this.sourceReceiver, this.namingControl);
        }
    }
}

