/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.dsl;

import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.apm.network.logging.v3.LogDataBody;
import org.apache.skywalking.apm.network.logging.v3.LogTags;
import org.apache.skywalking.apm.network.logging.v3.TraceContext;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.transform.stc.AbstractTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;

public class LALPrecompiledExtension
extends AbstractTypeCheckingExtension {
    public LALPrecompiledExtension(StaticTypeCheckingVisitor typeCheckingVisitor) {
        super(typeCheckingVisitor);
    }

    public boolean handleUnresolvedProperty(PropertyExpression pexp) {
        Expression exp = pexp.getObjectExpression();
        if (exp.getText().startsWith("parsed")) {
            this.makeDynamic(pexp);
            this.setHandled(true);
            return true;
        }
        if (exp.getText().startsWith("log") && this.handleLogVariable(pexp)) {
            return true;
        }
        return super.handleUnresolvedProperty(pexp);
    }

    private boolean handleLogVariable(PropertyExpression pexp) {
        Expression exp = pexp.getObjectExpression();
        Expression p = pexp.getProperty();
        if (exp instanceof VariableExpression) {
            VariableExpression v = (VariableExpression)exp;
            if (v.getName().equals("log")) {
                this.storeType((Expression)v, ClassHelper.makeCached(LogData.Builder.class));
            }
            if (p instanceof ConstantExpression) {
                ConstantExpression c = (ConstantExpression)p;
                switch (c.getText()) {
                    case "body": {
                        this.storeType((Expression)pexp, ClassHelper.makeCached(LogDataBody.class));
                        break;
                    }
                    case "traceContext": {
                        this.storeType((Expression)pexp, ClassHelper.makeCached(TraceContext.class));
                        break;
                    }
                    case "tags": {
                        this.storeType((Expression)pexp, ClassHelper.makeCached(LogTags.class));
                    }
                }
            }
            this.setHandled(true);
            return true;
        }
        return false;
    }
}

