/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunction;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.grpc.StatusAndMetadata;
import com.linecorp.armeria.internal.common.grpc.StatusExceptionConverter;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Objects;

public final class InternalGrpcExceptionHandler {
    private final GrpcExceptionHandlerFunction delegate;

    public InternalGrpcExceptionHandler(GrpcExceptionHandlerFunction delegate) {
        this.delegate = delegate;
    }

    public StatusAndMetadata handle(RequestContext ctx, Throwable t) {
        Throwable peeled = InternalGrpcExceptionHandler.peelAndUnwrap(t);
        Metadata metadata = Status.trailersFromThrowable((Throwable)peeled);
        if (metadata == null) {
            metadata = new Metadata();
        }
        Status status = Status.fromThrowable((Throwable)peeled);
        status = this.handle0(ctx, status, peeled, metadata);
        return new StatusAndMetadata(status, metadata);
    }

    public Status handle(RequestContext ctx, Status status, Throwable cause, Metadata metadata) {
        Throwable peeled = InternalGrpcExceptionHandler.peelAndUnwrap(cause);
        return this.handle0(ctx, status, peeled, metadata);
    }

    private Status handle0(RequestContext ctx, Status status, Throwable cause, Metadata metadata) {
        if (status.getCode() == Status.Code.UNKNOWN) {
            Status newStatus = null;
            if (cause instanceof StatusRuntimeException) {
                newStatus = ((StatusRuntimeException)cause).getStatus();
            } else if (cause instanceof StatusException) {
                newStatus = ((StatusException)cause).getStatus();
            }
            if (newStatus != null && newStatus.getCode() != Status.Code.UNKNOWN) {
                status = newStatus;
            }
        }
        status = this.delegate.apply(ctx, status, cause, metadata);
        assert (status != null);
        return status;
    }

    private static Throwable peelAndUnwrap(Throwable t) {
        Objects.requireNonNull(t, "t");
        for (Throwable cause = t = Exceptions.peel((Throwable)t); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ArmeriaStatusException)) continue;
            return StatusExceptionConverter.toGrpc((ArmeriaStatusException)cause);
        }
        return t;
    }
}

