/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.grpc.GrpcStatus;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.grpc.Status;
import java.util.Objects;

@FunctionalInterface
public interface UnframedGrpcStatusMappingFunction {
    public static UnframedGrpcStatusMappingFunction of() {
        return (ctx, status, response) -> GrpcStatus.grpcStatusToHttpStatus(ctx, status);
    }

    @Nullable
    public HttpStatus apply(ServiceRequestContext var1, Status var2, @Nullable Throwable var3);

    default public UnframedGrpcStatusMappingFunction orElse(UnframedGrpcStatusMappingFunction other) {
        Objects.requireNonNull(other, "other");
        if (this == other) {
            return this;
        }
        return (ctx, status, cause) -> {
            HttpStatus httpStatus = this.apply(ctx, status, cause);
            if (httpStatus != null) {
                return httpStatus;
            }
            return other.apply(ctx, status, cause);
        };
    }
}

