/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config.group;

import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.config.group.uri.quickmatch.QuickUriGroupingRule;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class EndpointGroupingRuleReader {
    private Map yamlData;

    public EndpointGroupingRuleReader(InputStream inputStream) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        this.yamlData = (Map)yaml.load(inputStream);
    }

    public EndpointGroupingRuleReader(Reader io) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        this.yamlData = (Map)yaml.load(io);
    }

    QuickUriGroupingRule read() {
        List rulesData;
        QuickUriGroupingRule quickUriGroupingRule = new QuickUriGroupingRule();
        if (Objects.nonNull(this.yamlData) && (rulesData = (List)this.yamlData.get("grouping")) != null) {
            rulesData.forEach(ruleObj -> {
                Map rule = (Map)ruleObj;
                String serviceName = (String)rule.get("service-name");
                if (StringUtil.isEmpty((String)serviceName)) {
                    throw new IllegalArgumentException("service-name can't be empty");
                }
                List endpointRules = (List)rule.get("rules");
                if (endpointRules != null) {
                    endpointRules.forEach(endpointRuleObj -> {
                        String pattern = (String)endpointRuleObj;
                        if (StringUtil.isEmpty((String)pattern)) {
                            return;
                        }
                        quickUriGroupingRule.addRule(serviceName, pattern);
                    });
                }
            });
        }
        return quickUriGroupingRule;
    }
}

