/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.management.ui.menu;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.management.ui.menu.UIMenuItemSetting;
import org.apache.skywalking.oap.server.core.management.ui.menu.UIMenuManagementService;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class UIMenuInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UIMenuInitializer.class);
    private final UIMenuManagementService uiMenuManagementService;

    public UIMenuInitializer(ModuleManager manager) {
        this.uiMenuManagementService = (UIMenuManagementService)manager.find("core").provider().getService(UIMenuManagementService.class);
    }

    public void init() throws IOException {
        String menuFile = "ui-initialized-templates/menu.yaml";
        try {
            Reader menuReader = ResourceUtils.read((String)"ui-initialized-templates/menu.yaml");
            Yaml yaml = new Yaml();
            MenuData menuData = (MenuData)yaml.loadAs(menuReader, MenuData.class);
            if (menuData == null || CollectionUtils.isEmpty(menuData.getMenus())) {
                throw new IllegalArgumentException("cannot reading any menu items.");
            }
            this.uiMenuManagementService.saveMenu(menuData.getMenus());
        }
        catch (FileNotFoundException e) {
            log.debug("No such file of path: {}, skipping loading UI menu.", (Object)"ui-initialized-templates/menu.yaml");
        }
    }

    public static class MenuData {
        private List<UIMenuItemSetting> menus;

        @Generated
        public void setMenus(List<UIMenuItemSetting> menus) {
            this.menus = menus;
        }

        @Generated
        public List<UIMenuItemSetting> getMenus() {
            return this.menus;
        }
    }
}

