/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf.storage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.UnexpectedException;

public enum EBPFProfilingStackType {
    UNKNOWN(0, null),
    KERNEL_SPACE(1, org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingStackType.PROCESS_KERNEL_SPACE),
    USER_SPACE(2, org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingStackType.PROCESS_USER_SPACE);

    private final int value;
    private final org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingStackType mapping;
    private static final Map<Integer, EBPFProfilingStackType> DICTIONARY;
    private static final Map<org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingStackType, EBPFProfilingStackType> MAPPING;

    private EBPFProfilingStackType(int value, org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingStackType mapping) {
        this.value = value;
        this.mapping = mapping;
    }

    public int value() {
        return this.value;
    }

    public org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingStackType mapping() {
        return this.mapping;
    }

    public static EBPFProfilingStackType valueOf(int value) {
        EBPFProfilingStackType type = DICTIONARY.get(value);
        if (type == null) {
            throw new UnexpectedException("Unknown EBPFProfilingStackType value");
        }
        return type;
    }

    public static EBPFProfilingStackType valueOf(org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingStackType protocolStackType) {
        EBPFProfilingStackType type = MAPPING.get(protocolStackType);
        if (type == null) {
            throw new UnexpectedException("Unknown EBPFProfilingStackType value");
        }
        return type;
    }

    static {
        DICTIONARY = new HashMap<Integer, EBPFProfilingStackType>();
        MAPPING = new HashMap<org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingStackType, EBPFProfilingStackType>();
        Arrays.stream(EBPFProfilingStackType.values()).collect(Collectors.toMap(EBPFProfilingStackType::value, type -> type)).forEach(DICTIONARY::put);
        Arrays.stream(EBPFProfilingStackType.values()).collect(Collectors.toMap(EBPFProfilingStackType::mapping, type -> type)).forEach(MAPPING::put);
    }
}

