/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.remote;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.Empty;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteMessage;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteServiceGrpc;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.core.worker.IWorkerInstanceGetter;
import org.apache.skywalking.oap.server.core.worker.RemoteHandleWorker;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServiceHandler
extends RemoteServiceGrpc.RemoteServiceImplBase
implements GRPCHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteServiceHandler.class);
    private final ModuleDefineHolder moduleDefineHolder;
    private IWorkerInstanceGetter workerInstanceGetter;
    private CounterMetrics remoteInCounter;
    private CounterMetrics remoteInErrorCounter;
    private CounterMetrics remoteInTargetNotFoundCounter;
    private HistogramMetrics remoteInHistogram;

    public RemoteServiceHandler(ModuleDefineHolder moduleDefineHolder) {
        this.moduleDefineHolder = moduleDefineHolder;
        this.remoteInCounter = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createCounter("remote_in_count", "The number(server side) of inside remote inside aggregate rpc.", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.remoteInErrorCounter = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createCounter("remote_in_error_count", "The error number(server side) of inside remote inside aggregate rpc.", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.remoteInTargetNotFoundCounter = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createCounter("remote_in_target_not_found_count", "The error number(server side) of inside remote handler target worker not found. May be caused by unmatched OAL scrips.", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.remoteInHistogram = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createHistogramMetric("remote_in_latency", "The latency(server side) of inside remote inside aggregate rpc.", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StreamObserver<RemoteMessage> call(final StreamObserver<Empty> responseObserver) {
        if (!Objects.isNull(this.workerInstanceGetter)) return new StreamObserver<RemoteMessage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(RemoteMessage message) {
                block10: {
                    RemoteServiceHandler.this.remoteInCounter.inc();
                    HistogramMetrics.Timer timer = RemoteServiceHandler.this.remoteInHistogram.createTimer();
                    try {
                        String nextWorkerName = message.getNextWorkerName();
                        RemoteData remoteData = message.getRemoteData();
                        RemoteHandleWorker handleWorker = RemoteServiceHandler.this.workerInstanceGetter.get(nextWorkerName);
                        if (handleWorker != null) {
                            StreamData streamData;
                            AbstractWorker nextWorker = handleWorker.getWorker();
                            try {
                                streamData = handleWorker.getStreamDataClass().newInstance();
                            }
                            catch (Throwable t) {
                                RemoteServiceHandler.this.remoteInErrorCounter.inc();
                                LOGGER.error(t.getMessage(), t);
                                timer.finish();
                                return;
                            }
                            try {
                                streamData.deserialize(remoteData);
                            }
                            catch (Throwable t) {
                                RemoteServiceHandler.this.remoteInErrorCounter.inc();
                                LOGGER.error("Can't deserialize data {}, this data is discarded.", (Object)message, (Object)t);
                                timer.finish();
                                return;
                            }
                            nextWorker.in(streamData);
                            break block10;
                        }
                        RemoteServiceHandler.this.remoteInTargetNotFoundCounter.inc();
                        LOGGER.warn("Data is discarded due to worker not found. Check OAL/MAL script, make sure they are aligned in the whole cluster. The data is {}", (Object)message);
                    }
                    finally {
                        timer.finish();
                    }
                }
            }

            public void onError(Throwable throwable) {
                Status status = Status.fromThrowable((Throwable)throwable);
                if (Status.CANCELLED.getCode() == status.getCode()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(throwable.getMessage(), throwable);
                    }
                    return;
                }
                LOGGER.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Empty.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
        Class<RemoteServiceHandler> clazz = RemoteServiceHandler.class;
        synchronized (RemoteServiceHandler.class) {
            if (!Objects.isNull(this.workerInstanceGetter)) return new /* invalid duplicate definition of identical inner class */;
            this.workerInstanceGetter = (IWorkerInstanceGetter)this.moduleDefineHolder.find("core").provider().getService(IWorkerInstanceGetter.class);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new /* invalid duplicate definition of identical inner class */;
        }
    }
}

