/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.remote.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.netty.handler.ssl.SslContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterWatcher;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.core.remote.client.GRPCRemoteClient;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClient;
import org.apache.skywalking.oap.server.core.remote.client.SelfRemoteClient;
import org.apache.skywalking.oap.server.core.status.ServerStatusService;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.server.grpc.ssl.DynamicSslContext;
import org.apache.skywalking.oap.server.library.server.ssl.AbstractSslContext;
import org.apache.skywalking.oap.server.library.util.RunnableWithExceptionProtection;
import org.apache.skywalking.oap.server.telemetry.api.GaugeMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClientManager
implements Service,
ClusterWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteClientManager.class);
    private final ModuleDefineHolder moduleDefineHolder;
    private DynamicSslContext sslContext;
    private ClusterNodesQuery clusterNodesQuery;
    private volatile List<RemoteClient> usingClients;
    private GaugeMetrics gauge;
    private int remoteTimeout;

    public RemoteClientManager(ModuleDefineHolder moduleDefineHolder, int remoteTimeout, String trustedCAFile) {
        this(moduleDefineHolder, remoteTimeout);
        this.sslContext = DynamicSslContext.forClient((String)trustedCAFile);
    }

    public RemoteClientManager(ModuleDefineHolder moduleDefineHolder, int remoteTimeout) {
        this.moduleDefineHolder = moduleDefineHolder;
        this.usingClients = ImmutableList.of();
        this.remoteTimeout = remoteTimeout;
    }

    public void start() {
        Optional.ofNullable(this.sslContext).ifPresent(AbstractSslContext::start);
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay((Runnable)new RunnableWithExceptionProtection(this::refresh, t -> log.error("Scheduled refresh Remote Clients failure.", t)), 1L, 10L, TimeUnit.SECONDS);
    }

    void refresh() {
        if (Objects.isNull(this.clusterNodesQuery)) {
            this.clusterNodesQuery = (ClusterNodesQuery)this.moduleDefineHolder.find("cluster").provider().getService(ClusterNodesQuery.class);
        }
        this.refresh(this.clusterNodesQuery.queryRemoteNodes());
    }

    synchronized void refresh(List<RemoteInstance> instanceList) {
        if (this.gauge == null) {
            this.gauge = ((MetricsCreator)this.moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createGauge("cluster_size", "Cluster size of current oap node", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Refresh remote nodes collection.");
            }
            instanceList = this.distinct(instanceList);
            Collections.sort(instanceList);
            this.gauge.setValue((double)instanceList.size());
            if (log.isDebugEnabled()) {
                instanceList.forEach(instance -> log.debug("Cluster instance: {}", (Object)instance.toString()));
            }
            if (!this.compare(instanceList)) {
                if (log.isDebugEnabled()) {
                    log.debug("ReBuilding remote clients.");
                }
                this.reBuildRemoteClients(instanceList);
                ((ServerStatusService)this.moduleDefineHolder.find("core").provider().getService(ServerStatusService.class)).rebalancedCluster(System.currentTimeMillis());
            }
            this.printRemoteClientList();
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
    }

    private void printRemoteClientList() {
        if (log.isDebugEnabled()) {
            StringBuilder addresses = new StringBuilder();
            this.usingClients.forEach(client -> addresses.append(client.getAddress().toString()).append(","));
            log.debug("Remote client list: {}", (Object)addresses);
        }
    }

    private List<RemoteInstance> distinct(List<RemoteInstance> instanceList) {
        HashSet addresses = new HashSet();
        ArrayList<RemoteInstance> newInstanceList = new ArrayList<RemoteInstance>();
        instanceList.forEach(instance -> {
            if (addresses.add(instance.getAddress())) {
                newInstanceList.add((RemoteInstance)instance);
            }
        });
        return newInstanceList;
    }

    public List<RemoteClient> getRemoteClient() {
        return this.usingClients;
    }

    private void reBuildRemoteClients(List<RemoteInstance> remoteInstances) {
        Map<Address, RemoteClientAction> remoteClientCollection = this.usingClients.stream().collect(Collectors.toMap(RemoteClient::getAddress, client -> new RemoteClientAction((RemoteClient)client, Action.Close)));
        Map<Address, RemoteClientAction> latestRemoteClients = remoteInstances.stream().collect(Collectors.toMap(RemoteInstance::getAddress, remote -> new RemoteClientAction(null, Action.Create)));
        Sets.SetView unChangeAddresses = Sets.intersection(remoteClientCollection.keySet(), latestRemoteClients.keySet());
        unChangeAddresses.stream().filter(remoteClientCollection::containsKey).forEach(unChangeAddress -> ((RemoteClientAction)remoteClientCollection.get(unChangeAddress)).setAction(Action.Unchanged));
        unChangeAddresses.forEach(latestRemoteClients::remove);
        remoteClientCollection.putAll(latestRemoteClients);
        LinkedList newRemoteClients = new LinkedList();
        remoteClientCollection.forEach((address, clientAction) -> {
            switch (clientAction.getAction()) {
                case Unchanged: {
                    newRemoteClients.add(clientAction.getRemoteClient());
                    break;
                }
                case Create: {
                    if (address.isSelf()) {
                        SelfRemoteClient client = new SelfRemoteClient(this.moduleDefineHolder, (Address)address);
                        newRemoteClients.add(client);
                        break;
                    }
                    GRPCRemoteClient client = new GRPCRemoteClient(this.moduleDefineHolder, (Address)address, 1, 3000, this.remoteTimeout, (SslContext)this.sslContext);
                    client.connect();
                    newRemoteClients.add(client);
                }
            }
        });
        Collections.sort(newRemoteClients);
        this.usingClients = ImmutableList.copyOf(newRemoteClients);
        remoteClientCollection.values().stream().filter(remoteClientAction -> remoteClientAction.getAction().equals((Object)Action.Close) && !remoteClientAction.getRemoteClient().getAddress().isSelf()).forEach(remoteClientAction -> remoteClientAction.getRemoteClient().close());
    }

    private boolean compare(List<RemoteInstance> remoteInstances) {
        if (this.usingClients.size() == remoteInstances.size()) {
            for (int i = 0; i < this.usingClients.size(); ++i) {
                if (this.usingClients.get(i).getAddress().equals(remoteInstances.get(i).getAddress())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void onClusterNodesChanged(List<RemoteInstance> remoteInstances) {
        this.refresh(remoteInstances);
    }

    private static class RemoteClientAction {
        private RemoteClient remoteClient;
        private Action action;

        @Generated
        public RemoteClient getRemoteClient() {
            return this.remoteClient;
        }

        @Generated
        public Action getAction() {
            return this.action;
        }

        @Generated
        public RemoteClientAction(RemoteClient remoteClient, Action action) {
            this.remoteClient = remoteClient;
            this.action = action;
        }

        @Generated
        public void setAction(Action action) {
            this.action = action;
        }
    }

    static enum Action {
        Close,
        Unchanged,
        Create;

    }
}

