/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.source.MQOperation;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;
import org.apache.skywalking.oap.server.core.source.Source;

@ScopeDeclaration(id=64, name="MQEndpointAccess", catalog="ENDPOINT")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class MQEndpointAccess
extends Source {
    private String entityId;
    @ScopeDefaultColumn.DefinedByField(columnName="service_id")
    private String serviceId;
    @ScopeDefaultColumn.DefinedByField(columnName="service_name", requireDynamicActive=true)
    private String serviceName;
    @ScopeDefaultColumn.DefinedByField(columnName="endpoint", requireDynamicActive=true)
    private String endpoint;
    private int typeId;
    private long transmissionLatency;
    private boolean status;
    private MQOperation operation;

    @Override
    public int scope() {
        return 64;
    }

    @Override
    public String getEntityId() {
        if (this.entityId == null) {
            this.entityId = IDManager.EndpointID.buildId(this.serviceId, this.endpoint);
        }
        return this.entityId;
    }

    @Override
    public void prepare() {
        this.serviceId = IDManager.ServiceID.buildId(this.serviceName, false);
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public int getTypeId() {
        return this.typeId;
    }

    @Generated
    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    @Generated
    public long getTransmissionLatency() {
        return this.transmissionLatency;
    }

    @Generated
    public void setTransmissionLatency(long transmissionLatency) {
        this.transmissionLatency = transmissionLatency;
    }

    @Generated
    public boolean isStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(boolean status) {
        this.status = status;
    }

    @Generated
    public MQOperation getOperation() {
        return this.operation;
    }

    @Generated
    public void setOperation(MQOperation operation) {
        this.operation = operation;
    }
}

