/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.ISourceDecorator;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.SourceDecoratorManager;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.RequestType;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;
import org.apache.skywalking.oap.server.core.source.SideCar;
import org.apache.skywalking.oap.server.core.source.Source;

@ScopeDeclaration(id=1, name="Service", catalog="SERVICE")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class Service
extends Source {
    private volatile String entityId;
    @ScopeDefaultColumn.DefinedByField(columnName="name", requireDynamicActive=true)
    private String name;
    private Layer layer;
    private String serviceInstanceName;
    private String endpointName;
    private int latency;
    private boolean status;
    private int httpResponseStatusCode;
    private String rpcStatusCode;
    private RequestType type;
    private List<String> tags;
    private Map<String, String> originalTags;
    private SideCar sideCar = new SideCar();
    @ScopeDefaultColumn.DefinedByField(columnName="attr0", isAttribute=true)
    private String attr0;
    @ScopeDefaultColumn.DefinedByField(columnName="attr1", isAttribute=true)
    private String attr1;
    @ScopeDefaultColumn.DefinedByField(columnName="attr2", isAttribute=true)
    private String attr2;
    @ScopeDefaultColumn.DefinedByField(columnName="attr3", isAttribute=true)
    private String attr3;
    @ScopeDefaultColumn.DefinedByField(columnName="attr4", isAttribute=true)
    private String attr4;
    @ScopeDefaultColumn.DefinedByField(columnName="attr5", isAttribute=true)
    private String attr5;

    @Override
    public int scope() {
        return 1;
    }

    @Override
    public String getEntityId() {
        if (this.entityId == null) {
            this.entityId = IDManager.ServiceID.buildId(this.name, this.layer.isNormal());
        }
        return this.entityId;
    }

    public String getTag(String key) {
        return this.originalTags.get(key);
    }

    public void decorate(String decorator) {
        ISourceDecorator<ISource> sourceDecorator = SourceDecoratorManager.DECORATOR_MAP.get(decorator);
        sourceDecorator.decorate(this);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Generated
    public Layer getLayer() {
        return this.layer;
    }

    @Generated
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public void setServiceInstanceName(String serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public String getEndpointName() {
        return this.endpointName;
    }

    @Generated
    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    @Generated
    public int getLatency() {
        return this.latency;
    }

    @Generated
    public void setLatency(int latency) {
        this.latency = latency;
    }

    @Generated
    public boolean isStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(boolean status) {
        this.status = status;
    }

    @Generated
    public int getHttpResponseStatusCode() {
        return this.httpResponseStatusCode;
    }

    @Generated
    public void setHttpResponseStatusCode(int httpResponseStatusCode) {
        this.httpResponseStatusCode = httpResponseStatusCode;
    }

    @Generated
    public String getRpcStatusCode() {
        return this.rpcStatusCode;
    }

    @Generated
    public void setRpcStatusCode(String rpcStatusCode) {
        this.rpcStatusCode = rpcStatusCode;
    }

    @Generated
    public RequestType getType() {
        return this.type;
    }

    @Generated
    public void setType(RequestType type) {
        this.type = type;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setOriginalTags(Map<String, String> originalTags) {
        this.originalTags = originalTags;
    }

    @Generated
    public SideCar getSideCar() {
        return this.sideCar;
    }

    @Generated
    public void setSideCar(SideCar sideCar) {
        this.sideCar = sideCar;
    }

    @Generated
    public String getAttr0() {
        return this.attr0;
    }

    @Generated
    public void setAttr0(String attr0) {
        this.attr0 = attr0;
    }

    @Generated
    public String getAttr1() {
        return this.attr1;
    }

    @Generated
    public void setAttr1(String attr1) {
        this.attr1 = attr1;
    }

    @Generated
    public String getAttr2() {
        return this.attr2;
    }

    @Generated
    public void setAttr2(String attr2) {
        this.attr2 = attr2;
    }

    @Generated
    public String getAttr3() {
        return this.attr3;
    }

    @Generated
    public void setAttr3(String attr3) {
        this.attr3 = attr3;
    }

    @Generated
    public String getAttr4() {
        return this.attr4;
    }

    @Generated
    public void setAttr4(String attr4) {
        this.attr4 = attr4;
    }

    @Generated
    public String getAttr5() {
        return this.attr5;
    }

    @Generated
    public void setAttr5(String attr5) {
        this.attr5 = attr5;
    }
}

