/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.ttl;

import com.google.gson.Gson;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.ttl.MetricsTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.RecordsTTL;

public class TTLDefinition {
    private static final Gson GSON = new Gson();
    private final MetricsTTL metrics;
    private final RecordsTTL records;

    public String generateTTLDefinition() {
        StringBuilder ttlDefinition = new StringBuilder();
        ttlDefinition.append("# Metrics TTL includes the definition of the TTL of the metrics-ish data in the storage,\n");
        ttlDefinition.append("# e.g.\n");
        ttlDefinition.append("# 1. The metadata of the service, instance, endpoint, topology map, etc.\n");
        ttlDefinition.append("# 2. Generated metrics data from OAL and MAL engines.\n");
        ttlDefinition.append("#\n");
        ttlDefinition.append("# TTLs for each granularity metrics are listed separately.\n");
        ttlDefinition.append("metrics.minute=").append(this.metrics.getMinute()).append("\n");
        ttlDefinition.append("metrics.hour=").append(this.metrics.getHour()).append("\n");
        ttlDefinition.append("metrics.day=").append(this.metrics.getDay()).append("\n");
        ttlDefinition.append("\n");
        ttlDefinition.append("# Records TTL includes the definition of the TTL of the records data in the storage,\n");
        ttlDefinition.append("# Records include traces, logs, sampled slow SQL statements, HTTP requests(by Rover), alarms, etc.\n");
        ttlDefinition.append("# Super dataset of records are traces and logs, which volume should be much larger.\n");
        ttlDefinition.append("records.default=").append(this.records.getValue()).append("\n");
        ttlDefinition.append("records.superDataset=").append(this.records.getSuperDataset()).append("\n");
        return ttlDefinition.toString();
    }

    public String generateTTLDefinitionAsJSONStr() {
        return GSON.toJson((Object)this);
    }

    @Generated
    public TTLDefinition(MetricsTTL metrics, RecordsTTL records) {
        this.metrics = metrics;
        this.records = records;
    }

    @Generated
    public MetricsTTL getMetrics() {
        return this.metrics;
    }

    @Generated
    public RecordsTTL getRecords() {
        return this.records;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TTLDefinition)) {
            return false;
        }
        TTLDefinition other = (TTLDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricsTTL this$metrics = this.getMetrics();
        MetricsTTL other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        RecordsTTL this$records = this.getRecords();
        RecordsTTL other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TTLDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetricsTTL $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        RecordsTTL $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TTLDefinition(metrics=" + this.getMetrics() + ", records=" + this.getRecords() + ")";
    }
}

