/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.worker;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.core.worker.IWorkerInstanceGetter;
import org.apache.skywalking.oap.server.core.worker.IWorkerInstanceSetter;
import org.apache.skywalking.oap.server.core.worker.RemoteHandleWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerInstancesService
implements IWorkerInstanceSetter,
IWorkerInstanceGetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerInstancesService.class);
    private final Map<String, RemoteHandleWorker> instances = new HashMap<String, RemoteHandleWorker>();

    @Override
    public RemoteHandleWorker get(String nextWorkerName) {
        return this.instances.get(nextWorkerName);
    }

    @Override
    public void put(String remoteReceiverWorkName, AbstractWorker instance, Class<? extends StreamData> streamDataClass) {
        if (this.instances.containsKey(remoteReceiverWorkName)) {
            throw new UnexpectedException("Duplicate worker name:" + remoteReceiverWorkName);
        }
        this.instances.put(remoteReceiverWorkName, new RemoteHandleWorker(instance, streamDataClass));
        LOGGER.debug("Worker {} has been registered as {}", (Object)instance.toString(), (Object)remoteReceiverWorkName);
    }
}

