/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigTable;
import org.apache.skywalking.oap.server.configuration.api.ListeningConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.apollo.ApolloConfigurationCenterSettings;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloConfigWatcherRegister
extends ListeningConfigWatcherRegister {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApolloConfigWatcherRegister.class);
    private final Config configReader;

    public ApolloConfigWatcherRegister(ApolloConfigurationCenterSettings settings) {
        String namespace = settings.getNamespace();
        boolean isDefaultNamespace = Strings.isNullOrEmpty((String)namespace);
        if (isDefaultNamespace) {
            this.configReader = ConfigService.getAppConfig();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Read dynamic configs from Apollo default namespace");
            }
        } else {
            this.configReader = ConfigService.getConfig((String)namespace);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Read dynamic configs from Apollo namespace: {}", (Object)namespace);
            }
        }
    }

    protected void startListening(ConfigWatcherRegister.WatcherHolder holder, ListeningConfigWatcherRegister.ConfigChangeCallback configChangeCallback) {
        String key = holder.getKey();
        switch (holder.getWatcher().getWatchType()) {
            case SINGLE: {
                String value = this.configReader.getProperty(key, null);
                if (value != null) {
                    configChangeCallback.onSingleValueChanged(holder, new ConfigTable.ConfigItem(key, value));
                }
                this.configReader.addChangeListener(changeEvent -> changeEvent.changedKeys().stream().filter(changedKey -> Objects.equals(changedKey, key)).findFirst().ifPresent(changedKey -> {
                    String newValue = changeEvent.getChange(changedKey).getNewValue();
                    configChangeCallback.onSingleValueChanged(holder, new ConfigTable.ConfigItem(changedKey, newValue));
                }), Collections.singleton(key));
                break;
            }
            case GROUP: {
                String groupPrefix = key + ".";
                Set allKeys = this.configReader.getPropertyNames();
                if (CollectionUtils.isNotEmpty((Set)allKeys)) {
                    GroupConfigTable.GroupConfigItems groupConfigItems = new GroupConfigTable.GroupConfigItems(key);
                    allKeys.stream().filter(it -> it.startsWith(groupPrefix)).forEach(groupItemKey -> {
                        String itemName = groupItemKey.substring(groupPrefix.length());
                        String itemValue = this.configReader.getProperty(groupItemKey, null);
                        groupConfigItems.add(new ConfigTable.ConfigItem(itemName, itemValue));
                    });
                    configChangeCallback.onGroupValuesChanged(holder, groupConfigItems);
                }
                this.configReader.addChangeListener(changeEvent -> {
                    GroupConfigTable.GroupConfigItems newGroupConfigItems = new GroupConfigTable.GroupConfigItems(key);
                    for (String groupItemKey : changeEvent.changedKeys()) {
                        String itemName = groupItemKey.substring(groupPrefix.length());
                        String itemValue = changeEvent.getChange(groupItemKey).getNewValue();
                        newGroupConfigItems.add(new ConfigTable.ConfigItem(itemName, itemValue));
                    }
                    configChangeCallback.onGroupValuesChanged(holder, newGroupConfigItems);
                }, Collections.emptySet(), Collections.singleton(key));
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported watcher type.");
            }
        }
    }
}

