/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.mqe.rt.grammar.MQEParserBaseVisitor;
import org.apache.skywalking.mqe.rt.operation.AggregateLabelsOp;
import org.apache.skywalking.mqe.rt.operation.AggregationOp;
import org.apache.skywalking.mqe.rt.operation.BinaryOp;
import org.apache.skywalking.mqe.rt.operation.BoolOp;
import org.apache.skywalking.mqe.rt.operation.CompareOp;
import org.apache.skywalking.mqe.rt.operation.LogicalFunctionOp;
import org.apache.skywalking.mqe.rt.operation.MathematicalFunctionOp;
import org.apache.skywalking.mqe.rt.operation.SortLabelValuesOp;
import org.apache.skywalking.mqe.rt.operation.SortValuesOp;
import org.apache.skywalking.mqe.rt.operation.TopNOfOp;
import org.apache.skywalking.mqe.rt.operation.TrendOp;
import org.apache.skywalking.oap.server.ai.pipeline.services.BaselineQueryService;
import org.apache.skywalking.oap.server.ai.pipeline.services.PredictServiceMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataLabel;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResultType;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MQEVisitorBase
extends MQEParserBaseVisitor<ExpressionResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQEVisitorBase.class);
    private final BiFunction<String, Step, String> getPredictTimeBucket = (timePoint, step) -> {
        switch (step) {
            case MINUTE: {
                return Long.toString(Long.parseLong(timePoint) / 100L);
            }
            case HOUR: {
                return timePoint;
            }
            case DAY: {
                return Long.toString(Long.parseLong(timePoint) * 100L);
            }
        }
        throw new IllegalArgumentException("Unsupported time step: " + step);
    };
    private BaselineQueryService baselineQueryService;
    protected final ModuleManager moduleManager;
    public final Step queryStep;

    protected MQEVisitorBase(ModuleManager moduleManager, Step queryStep) {
        this.moduleManager = moduleManager;
        this.queryStep = queryStep;
    }

    private BaselineQueryService getBaselineQueryService() {
        if (this.baselineQueryService == null) {
            this.baselineQueryService = (BaselineQueryService)this.moduleManager.find("ai-pipeline").provider().getService(BaselineQueryService.class);
        }
        return this.baselineQueryService;
    }

    public ExpressionResult visitParensOp(MQEParser.ParensOpContext ctx) {
        ExpressionResult result = (ExpressionResult)this.visit((ParseTree)ctx.expression());
        if (result.isBoolResult() && !(ctx.parent instanceof MQEParser.BoolOPContext) && !(ctx.parent instanceof MQEParser.ParensOpContext)) {
            result.setBoolResult(false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitAddSubOp(MQEParser.AddSubOpContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Binary OP: " + ctx.getText());
        try {
            ExpressionResult left = (ExpressionResult)this.visit((ParseTree)ctx.expression(0));
            if (StringUtil.isNotBlank((String)left.getError())) {
                ExpressionResult expressionResult = left;
                return expressionResult;
            }
            ExpressionResult right = (ExpressionResult)this.visit((ParseTree)ctx.expression(1));
            if (StringUtil.isNotBlank((String)right.getError())) {
                ExpressionResult expressionResult = right;
                return expressionResult;
            }
            int opType = ctx.addSub().getStart().getType();
            try {
                ExpressionResult expressionResult = BinaryOp.doBinaryOp(left, right, opType);
                return expressionResult;
            }
            catch (IllegalExpressionException e) {
                ExpressionResult expressionResult = this.getErrorResult(e.getMessage());
                traceContext.stopSpan(span);
                return expressionResult;
            }
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitMulDivModOp(MQEParser.MulDivModOpContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Binary OP: " + ctx.getText());
        try {
            ExpressionResult left = (ExpressionResult)this.visit((ParseTree)ctx.expression(0));
            if (StringUtil.isNotBlank((String)left.getError())) {
                ExpressionResult expressionResult = left;
                return expressionResult;
            }
            ExpressionResult right = (ExpressionResult)this.visit((ParseTree)ctx.expression(1));
            if (StringUtil.isNotBlank((String)right.getError())) {
                ExpressionResult expressionResult = right;
                return expressionResult;
            }
            int opType = ctx.mulDivMod().getStart().getType();
            try {
                ExpressionResult expressionResult = BinaryOp.doBinaryOp(left, right, opType);
                return expressionResult;
            }
            catch (IllegalExpressionException e) {
                ExpressionResult expressionResult = this.getErrorResult(e.getMessage());
                traceContext.stopSpan(span);
                return expressionResult;
            }
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitScalar(MQEParser.ScalarContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Scalar: " + ctx.getText());
        try {
            ExpressionResult result = new ExpressionResult();
            double value = Double.parseDouble(ctx.getText());
            MQEValue mqeValue = new MQEValue();
            mqeValue.setDoubleValue(value);
            mqeValue.setEmptyValue(false);
            MQEValues mqeValues = new MQEValues();
            mqeValues.getValues().add(mqeValue);
            result.getResults().add(mqeValues);
            result.setType(ExpressionResultType.SINGLE_VALUE);
            ExpressionResult expressionResult = result;
            return expressionResult;
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitAggregationOp(MQEParser.AggregationOpContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Aggregation OP: " + ctx.getText());
        try {
            int opType = ctx.aggregation().getStart().getType();
            ExpressionResult expResult = (ExpressionResult)this.visit((ParseTree)ctx.expression());
            if (StringUtil.isNotEmpty((String)expResult.getError())) {
                ExpressionResult expressionResult = expResult;
                return expressionResult;
            }
            ExpressionResult expressionResult = AggregationOp.doAggregationOp(expResult, opType);
            return expressionResult;
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitAggregateLabelsOp(MQEParser.AggregateLabelsOpContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Aggregate Labels OP: " + ctx.getText());
        try {
            int funcType = ctx.aggregateLabelsFunc().getStart().getType();
            ExpressionResult expResult = (ExpressionResult)this.visit((ParseTree)ctx.expression());
            if (StringUtil.isNotEmpty((String)expResult.getError())) {
                ExpressionResult expressionResult = expResult;
                return expressionResult;
            }
            if (!expResult.isLabeledResult()) {
                expResult.setError("The result of expression [" + ctx.expression().getText() + "] is not a labeled result.");
                ExpressionResult expressionResult = expResult;
                return expressionResult;
            }
            if (expResult.getResults().isEmpty()) {
                ExpressionResult expressionResult = expResult;
                return expressionResult;
            }
            ArrayList<String> labelNames = new ArrayList<String>();
            MQEParser.LabelNameListContext labelNameListContext = ctx.aggregateLabelsFunc().labelNameList();
            if (null != labelNameListContext) {
                for (MQEParser.LabelNameContext labelNameContext : labelNameListContext.labelName()) {
                    if (!((MQEValues)expResult.getResults().get(0)).getMetric().getLabels().stream().anyMatch(label -> label.getKey().equals(labelNameContext.getText()))) continue;
                    labelNames.add(labelNameContext.getText());
                }
            }
            ExpressionResult expressionResult = AggregateLabelsOp.doAggregateLabelsOp(expResult, funcType, labelNames);
            return expressionResult;
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitMathematicalOperator0OP(MQEParser.MathematicalOperator0OPContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Mathematical OP: " + ctx.getText());
        try {
            int opType = ctx.mathematical_operator0().getStart().getType();
            ExpressionResult expResult = (ExpressionResult)this.visit((ParseTree)ctx.expression());
            if (StringUtil.isNotEmpty((String)expResult.getError())) {
                ExpressionResult expressionResult = expResult;
                return expressionResult;
            }
            ExpressionResult expressionResult = MathematicalFunctionOp.doFunction0Op(expResult, opType);
            return expressionResult;
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitMathematicalOperator1OP(MQEParser.MathematicalOperator1OPContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Mathematical OP: " + ctx.getText());
        try {
            int opType = ctx.mathematical_operator1().getStart().getType();
            ExpressionResult expResult = (ExpressionResult)this.visit((ParseTree)ctx.expression());
            if (StringUtil.isNotEmpty((String)expResult.getError())) {
                ExpressionResult expressionResult = expResult;
                return expressionResult;
            }
            ExpressionResult expressionResult = MathematicalFunctionOp.doFunction1Op(expResult, opType, Integer.parseInt(ctx.parameter().INTEGER().getText()));
            return expressionResult;
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitTopNOP(MQEParser.TopNOPContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE TopN OP: " + ctx.getText());
        try {
            ExpressionResult expressionResult = (ExpressionResult)this.visit((ParseTree)ctx.topN().metric());
            return expressionResult;
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitTopNOfOP(MQEParser.TopNOfOPContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE TopNOf OP: " + ctx.getText());
        try {
            List topNContexts = ctx.topN();
            ArrayList<ExpressionResult> topNResults = new ArrayList<ExpressionResult>();
            for (MQEParser.TopNContext topNContext : topNContexts) {
                topNResults.add((ExpressionResult)this.visit((ParseTree)topNContext.metric()));
            }
            try {
                ExpressionResult expressionResult = TopNOfOp.doMergeTopNResult(topNResults, Integer.parseInt(ctx.INTEGER().getText()), ctx.order().getStart().getType());
                return expressionResult;
            }
            catch (IllegalExpressionException e) {
                ExpressionResult expressionResult = this.getErrorResult(e.getMessage());
                traceContext.stopSpan(span);
                return expressionResult;
            }
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitRelablesOP(MQEParser.RelablesOPContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Relabels OP: " + ctx.getText());
        try {
            ExpressionResult result = (ExpressionResult)this.visit((ParseTree)ctx.expression());
            if (!result.isLabeledResult()) {
                result.setError("The result of expression [" + ctx.expression().getText() + "] is not a labeled result.");
                ExpressionResult expressionResult = result;
                return expressionResult;
            }
            KeyValue targetLabel = this.buildLabel(ctx.label());
            KeyValue replaceLabel = this.buildLabel(ctx.replaceLabel().label());
            List<KeyValue> targetLabels = this.parseLabelValue(targetLabel, ",");
            List<KeyValue> replaceLabels = this.parseLabelValue(replaceLabel, ",");
            HashMap<KeyValue, KeyValue> relabelMap = new HashMap<KeyValue, KeyValue>();
            if (targetLabels.isEmpty() || replaceLabels.isEmpty()) {
                ExpressionResult expressionResult = result;
                return expressionResult;
            }
            if (targetLabels.size() != replaceLabels.size()) {
                result.setError("Target label [" + targetLabel.getKey() + "]: the number of relabel values is not equal to the number of replace label.");
                ExpressionResult expressionResult = result;
                return expressionResult;
            }
            for (int i = 0; i < targetLabels.size(); ++i) {
                relabelMap.put(targetLabels.get(i), replaceLabels.get(i));
            }
            for (MQEValues mqeValues : result.getResults()) {
                for (KeyValue label : mqeValues.getMetric().getLabels()) {
                    if (!relabelMap.containsKey(label)) continue;
                    KeyValue replaceLabelValue = (KeyValue)relabelMap.get(label);
                    label.setKey(replaceLabelValue.getKey());
                    label.setValue(replaceLabelValue.getValue());
                }
            }
            ExpressionResult expressionResult = result;
            return expressionResult;
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitLogicalOperatorOP(MQEParser.LogicalOperatorOPContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Logical OP: " + ctx.getText());
        try {
            int opType = ctx.logical_operator().getStart().getType();
            try {
                ExpressionResult expressionResult = LogicalFunctionOp.doOP(opType, ctx.expressionList(), this);
                return expressionResult;
            }
            catch (IllegalExpressionException e) {
                ExpressionResult expressionResult = this.getErrorResult(e.getMessage());
                traceContext.stopSpan(span);
                return expressionResult;
            }
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitCompareOp(MQEParser.CompareOpContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Compare OP: " + ctx.getText());
        try {
            ExpressionResult left = (ExpressionResult)this.visit((ParseTree)ctx.expression(0));
            if (StringUtil.isNotBlank((String)left.getError())) {
                ExpressionResult expressionResult = left;
                return expressionResult;
            }
            ExpressionResult right = (ExpressionResult)this.visit((ParseTree)ctx.expression(1));
            if (StringUtil.isNotBlank((String)right.getError())) {
                ExpressionResult expressionResult = right;
                return expressionResult;
            }
            int opType = ctx.compare().getStart().getType();
            try {
                ExpressionResult result = CompareOp.doCompareOP(left, right, opType);
                if (ctx.parent == null || ctx.parent instanceof MQEParser.ParensOpContext || ctx.parent instanceof MQEParser.BoolOPContext) {
                    result.setBoolResult(true);
                }
                ExpressionResult expressionResult = result;
                return expressionResult;
            }
            catch (IllegalExpressionException e) {
                ExpressionResult expressionResult = this.getErrorResult(e.getMessage());
                traceContext.stopSpan(span);
                return expressionResult;
            }
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitTrendOP(MQEParser.TrendOPContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Trend OP: " + ctx.getText());
        try {
            int opType = ctx.trend().getStart().getType();
            int trendRange = Integer.parseInt(ctx.INTEGER().getText());
            if (trendRange < 1) {
                ExpressionResult expressionResult = this.getErrorResult("The trend range must be greater than 0.");
                return expressionResult;
            }
            ExpressionResult expResult = (ExpressionResult)this.visit((ParseTree)ctx.metric());
            if (StringUtil.isNotEmpty((String)expResult.getError())) {
                ExpressionResult expressionResult = expResult;
                return expressionResult;
            }
            if (expResult.getType() != ExpressionResultType.TIME_SERIES_VALUES) {
                expResult.setError("The result of expression [" + ctx.metric().getText() + "] is not a time series result.");
                ExpressionResult expressionResult = expResult;
                return expressionResult;
            }
            ExpressionResult expressionResult = TrendOp.doTrendOp(expResult, opType, trendRange, this.queryStep);
            return expressionResult;
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitSortValuesOP(MQEParser.SortValuesOPContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Sort Values OP: " + ctx.getText());
        try {
            ExpressionResult result = (ExpressionResult)this.visit((ParseTree)ctx.expression());
            int order = ctx.order().getStart().getType();
            Optional<Integer> limit = Optional.empty();
            if (ctx.INTEGER() != null) {
                limit = Optional.of(Integer.valueOf(ctx.INTEGER().getText()));
            }
            try {
                ExpressionResult expressionResult = SortValuesOp.doSortValuesOp(result, limit, order);
                return expressionResult;
            }
            catch (IllegalExpressionException e) {
                ExpressionResult expressionResult = this.getErrorResult(e.getMessage());
                traceContext.stopSpan(span);
                return expressionResult;
            }
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitSortLabelValuesOP(MQEParser.SortLabelValuesOPContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Sort Label Values OP: " + ctx.getText());
        try {
            ExpressionResult result = (ExpressionResult)this.visit((ParseTree)ctx.expression());
            int order = ctx.order().getStart().getType();
            ArrayList<String> labelNames = new ArrayList<String>();
            for (MQEParser.LabelNameContext labelNameContext : ctx.labelNameList().labelName()) {
                labelNames.add(labelNameContext.getText());
            }
            try {
                ExpressionResult expressionResult = SortLabelValuesOp.doSortLabelValuesOp(result, order, labelNames);
                return expressionResult;
            }
            catch (IllegalExpressionException e) {
                ExpressionResult expressionResult = this.getErrorResult(e.getMessage());
                traceContext.stopSpan(span);
                return expressionResult;
            }
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitBoolOP(MQEParser.BoolOPContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Bool OP: " + ctx.getText());
        try {
            ExpressionResult left = (ExpressionResult)this.visit((ParseTree)ctx.expression(0));
            if (StringUtil.isNotBlank((String)left.getError())) {
                ExpressionResult expressionResult = left;
                return expressionResult;
            }
            ExpressionResult right = (ExpressionResult)this.visit((ParseTree)ctx.expression(1));
            if (StringUtil.isNotBlank((String)right.getError())) {
                ExpressionResult expressionResult = right;
                return expressionResult;
            }
            int opType = ctx.bool_operator().getStart().getType();
            try {
                ExpressionResult result = BoolOp.doBoolOp(left, right, opType);
                if (ctx.parent == null || ctx.parent instanceof MQEParser.ParensOpContext || ctx.parent instanceof MQEParser.BoolOPContext) {
                    result.setBoolResult(true);
                }
                ExpressionResult expressionResult = result;
                return expressionResult;
            }
            catch (IllegalExpressionException e) {
                ExpressionResult expressionResult = this.getErrorResult(e.getMessage());
                traceContext.stopSpan(span);
                return expressionResult;
            }
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionResult visitBaselineOP(MQEParser.BaselineOPContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Baseline OP: " + ctx.getText());
        try {
            ExpressionResult expressionResult = (ExpressionResult)this.visit((ParseTree)ctx.metric());
            return expressionResult;
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    public abstract ExpressionResult visitMetric(MQEParser.MetricContext var1);

    protected KeyValue buildLabel(MQEParser.LabelContext ctx) {
        String labelName = ctx.labelName().getText();
        String labelValue = ctx.labelValue().getText();
        String labelValueTrim = labelValue.substring(1, labelValue.length() - 1);
        return new KeyValue(labelName, labelValueTrim);
    }

    protected List<KeyValue> buildLabels(MQEParser.LabelListContext ctx) {
        ArrayList<KeyValue> labels = new ArrayList<KeyValue>();
        if (ctx != null) {
            for (MQEParser.LabelContext labelContext : ctx.label()) {
                labels.add(this.buildLabel(labelContext));
            }
        }
        return labels;
    }

    protected List<KeyValue> parseLabelValue(KeyValue keyValue, String separator) {
        ArrayList<KeyValue> labels = new ArrayList<KeyValue>();
        if (keyValue != null && StringUtil.isNotBlank((String)keyValue.getValue())) {
            if (keyValue.getValue().indexOf(separator) > 0) {
                String[] subValues;
                for (String subValue : subValues = keyValue.getValue().split(separator)) {
                    labels.add(new KeyValue(keyValue.getKey(), subValue));
                }
            } else {
                labels.add(keyValue);
            }
        }
        return labels;
    }

    protected ExpressionResult getErrorResult(String error) {
        ExpressionResult result = new ExpressionResult();
        result.setType(ExpressionResultType.UNKNOWN);
        result.setError(error);
        return result;
    }

    protected List<MQEValues> queryBaseline(String serviceName, String metricName, ArrayList<String> pointOfTimes, int valueType) {
        ArrayList<MQEValues> mqeValuesList = new ArrayList<MQEValues>();
        MQEValues mqeValues = new MQEValues();
        for (String pointOfTime : pointOfTimes) {
            Map predictValues = this.getBaselineQueryService().queryPredictMetricsFromCache(serviceName, this.getPredictTimeBucket.apply(pointOfTime, this.queryStep));
            PredictServiceMetrics.PredictMetricsValue predictValue = (PredictServiceMetrics.PredictMetricsValue)predictValues.get(metricName);
            MQEValue mqeValue = new MQEValue();
            mqeValue.setId(pointOfTime);
            if (predictValue == null || predictValue.getSingleValue() == null) {
                mqeValue.setEmptyValue(true);
            } else {
                mqeValue.setDoubleValue((double)this.getValueByType(predictValue.getSingleValue(), valueType));
            }
            mqeValues.getValues().add(mqeValue);
        }
        mqeValuesList.add(mqeValues);
        return mqeValuesList;
    }

    protected List<MQEValues> queryLabeledBaseline(String serviceName, String metricName, List<KeyValue> queryLabels, ArrayList<String> pointOfTimes, int valueType) {
        HashMap<String, DataTable> timeValues = new HashMap<String, DataTable>();
        for (String pointOfTime : pointOfTimes) {
            Map predictValues = this.getBaselineQueryService().queryPredictMetricsFromCache(serviceName, this.getPredictTimeBucket.apply(pointOfTime, this.queryStep));
            PredictServiceMetrics.PredictMetricsValue predictValue = (PredictServiceMetrics.PredictMetricsValue)predictValues.get(metricName);
            if (predictValue == null || predictValue.getLabeledValue() == null) continue;
            DataTable dataTable = new DataTable();
            for (PredictServiceMetrics.PredictLabelValue labeledValue : predictValue.getLabeledValue()) {
                DataLabel dataLabel = new DataLabel();
                if (labeledValue == null) continue;
                dataLabel.putAll(labeledValue.getLabels());
                dataTable.put(dataLabel, Long.valueOf(this.getValueByType(labeledValue.getValue(), valueType)));
            }
            timeValues.put(pointOfTime, dataTable);
        }
        return this.buildLabledMqeValuesList(timeValues, queryLabels, pointOfTimes);
    }

    private long getValueByType(PredictServiceMetrics.PredictSingleValue predictSingleValue, int valueType) {
        switch (valueType) {
            case 54: {
                return predictSingleValue.getValue();
            }
            case 55: {
                return predictSingleValue.getUpperValue();
            }
            case 56: {
                return predictSingleValue.getLowerValue();
            }
        }
        throw new IllegalArgumentException("Unsupported predicted value type: " + valueType);
    }

    protected List<MQEValues> buildLabledMqeValuesList(Map<String, DataTable> timeValues, List<KeyValue> queryLabels, ArrayList<String> pointOfTimes) {
        ArrayList<MQEValues> mqeValuesList = new ArrayList<MQEValues>();
        List labelConditions = IMetricsQueryDAO.Util.composeLabelConditions(queryLabels, timeValues.values());
        for (String labelCondition : labelConditions) {
            MQEValues mqeValues = new MQEValues();
            for (String pointOfTime : pointOfTimes) {
                DataTable dataTable = timeValues.getOrDefault(pointOfTime, new DataTable());
                Long metricValue = dataTable.get(labelCondition);
                MQEValue mqeValue = new MQEValue();
                mqeValue.setId(pointOfTime);
                if (metricValue != null) {
                    mqeValue.setDoubleValue((double)metricValue.longValue());
                } else {
                    mqeValue.setEmptyValue(true);
                }
                mqeValues.getValues().add(mqeValue);
            }
            DataLabel dataLabel = new DataLabel();
            dataLabel.put(labelCondition);
            for (Map.Entry label : dataLabel.entrySet()) {
                mqeValues.getMetric().getLabels().add(new KeyValue((String)label.getKey(), (String)label.getValue()));
            }
            mqeValues.getMetric().sortLabelsByKey(Comparator.naturalOrder());
            mqeValuesList.add(mqeValues);
        }
        return mqeValuesList;
    }
}

