/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.jvm.provider.handler;

import io.grpc.stub.StreamObserver;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.agent.v3.JVMMetricCollection;
import org.apache.skywalking.apm.network.language.agent.v3.JVMMetricReportServiceGrpc;
import org.apache.skywalking.oap.server.analyzer.provider.jvm.JVMSourceDispatcher;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMMetricReportServiceHandler
extends JVMMetricReportServiceGrpc.JVMMetricReportServiceImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JVMMetricReportServiceHandler.class);
    private final JVMSourceDispatcher jvmSourceDispatcher;
    private final NamingControl namingControl;

    public JVMMetricReportServiceHandler(ModuleManager moduleManager) {
        this.jvmSourceDispatcher = new JVMSourceDispatcher(moduleManager);
        this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
    }

    public void collect(JVMMetricCollection request, StreamObserver<Commands> responseObserver) {
        if (log.isDebugEnabled()) {
            log.debug("receive the jvm metrics from service instance, name: {}, instance: {}", (Object)request.getService(), (Object)request.getServiceInstance());
        }
        JVMMetricCollection.Builder builder = request.toBuilder();
        builder.setService(this.namingControl.formatServiceName(builder.getService()));
        builder.setServiceInstance(this.namingControl.formatInstanceName(builder.getServiceInstance()));
        builder.getMetricsList().forEach(jvmMetric -> this.jvmSourceDispatcher.sendMetric(builder.getService(), builder.getServiceInstance(), jvmMetric));
        responseObserver.onNext((Object)Commands.newBuilder().build());
        responseObserver.onCompleted();
    }
}

