/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.grpc;

import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.grpc.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.grpc.AlarmServiceGrpc;
import org.apache.skywalking.oap.server.core.alarm.grpc.AlarmTags;
import org.apache.skywalking.oap.server.core.alarm.grpc.KeyStringValuePair;
import org.apache.skywalking.oap.server.core.alarm.grpc.Response;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.grpc.GRPCAlarmSetting;
import org.apache.skywalking.oap.server.library.client.grpc.GRPCClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.GRPCStreamStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCCallback
implements AlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GRPCCallback.class);
    private AlarmRulesWatcher alarmRulesWatcher;
    private Map<String, GRPCAlarmSetting> alarmSettingMap;
    private Map<String, AlarmServiceGrpc.AlarmServiceStub> alarmServiceStubMap;
    private Map<String, GRPCClient> grpcClientMap;

    public GRPCCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
        this.alarmSettingMap = new HashMap<String, GRPCAlarmSetting>();
        this.alarmServiceStubMap = new HashMap<String, AlarmServiceGrpc.AlarmServiceStub>();
        this.grpcClientMap = new HashMap<String, GRPCClient>();
        Map<String, GRPCAlarmSetting> alarmSettingMap = alarmRulesWatcher.getGrpchookSetting();
        if (CollectionUtils.isNotEmpty(alarmSettingMap)) {
            alarmSettingMap.forEach((name, alarmSetting) -> {
                if (alarmSetting != null && !alarmSetting.isEmptySetting()) {
                    GRPCClient grpcClient = new GRPCClient(alarmSetting.getTargetHost(), alarmSetting.getTargetPort());
                    grpcClient.connect();
                    this.grpcClientMap.put((String)name, grpcClient);
                    this.alarmServiceStubMap.put((String)name, AlarmServiceGrpc.newStub((Channel)grpcClient.getChannel()));
                }
            });
        }
    }

    public void doAlarm(List<AlarmMessage> alarmMessages) {
        Map<String, GRPCAlarmSetting> settinsMap = this.alarmRulesWatcher.getGrpchookSetting();
        this.onGRPCAlarmSettingUpdated(settinsMap);
        if (settinsMap == null || settinsMap.isEmpty()) {
            return;
        }
        Map groupedMessages = this.groupMessagesByHook(alarmMessages);
        groupedMessages.forEach((hook, messages) -> {
            if (this.alarmServiceStubMap.containsKey(hook)) {
                this.sendAlarmMessages(this.alarmServiceStubMap.get(hook), (List<AlarmMessage>)messages, (GRPCAlarmSetting)settinsMap.get(hook));
            }
        });
    }

    private void sendAlarmMessages(AlarmServiceGrpc.AlarmServiceStub alarmServiceStub, List<AlarmMessage> alarmMessages, GRPCAlarmSetting alarmSetting) {
        final GRPCStreamStatus status = new GRPCStreamStatus();
        StreamObserver<org.apache.skywalking.oap.server.core.alarm.grpc.AlarmMessage> streamObserver = ((AlarmServiceGrpc.AlarmServiceStub)alarmServiceStub.withDeadlineAfter(10L, TimeUnit.SECONDS)).doAlarm(new StreamObserver<Response>(){

            public void onNext(Response response) {
            }

            public void onError(Throwable throwable) {
                status.done();
                if (log.isDebugEnabled()) {
                    log.debug("Send alarm message failed: {}", (Object)throwable.getMessage());
                }
            }

            public void onCompleted() {
                status.done();
                if (log.isDebugEnabled()) {
                    log.debug("Send alarm message successful.");
                }
            }
        });
        alarmMessages.forEach(message -> {
            AlarmMessage.Builder builder = org.apache.skywalking.oap.server.core.alarm.grpc.AlarmMessage.newBuilder();
            builder.setScopeId(message.getScopeId());
            builder.setScope(message.getScope());
            builder.setName(message.getName());
            builder.setId0(message.getId0());
            builder.setId1(message.getId1());
            builder.setRuleName(message.getRuleName());
            builder.setAlarmMessage(message.getAlarmMessage());
            builder.setStartTime(message.getStartTime());
            AlarmTags.Builder alarmTagsBuilder = AlarmTags.newBuilder();
            message.getTags().forEach(m -> alarmTagsBuilder.addData(KeyStringValuePair.newBuilder().setKey(m.getKey()).setValue(m.getValue()).build()));
            builder.setTags(alarmTagsBuilder.build());
            streamObserver.onNext((Object)builder.build());
        });
        streamObserver.onCompleted();
        long sleepTime = 0L;
        long cycle = 100L;
        while (!status.isDone()) {
            try {
                sleepTime += cycle;
                Thread.sleep(cycle);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug("Send {} alarm message to {}:{}.", new Object[]{alarmMessages.size(), alarmSetting.getTargetHost(), alarmSetting.getTargetPort()});
            }
            if (sleepTime <= 2000L) continue;
            log.warn("Send {} alarm message to {}:{}, wait {} milliseconds.", new Object[]{alarmMessages.size(), alarmSetting.getTargetHost(), alarmSetting.getTargetPort(), sleepTime});
            cycle = 2000L;
        }
    }

    private void onGRPCAlarmSettingUpdated(Map<String, GRPCAlarmSetting> newAlarmSettingMap) {
        if (newAlarmSettingMap == null || newAlarmSettingMap.isEmpty()) {
            if (this.grpcClientMap != null) {
                this.grpcClientMap.forEach((name, grpcClient) -> {
                    grpcClient.shutdown();
                    log.debug("gRPC alarm hook target is empty, shutdown the old gRPC client.");
                });
            }
            this.alarmServiceStubMap = null;
            this.alarmSettingMap = null;
            return;
        }
        newAlarmSettingMap.forEach((name, newAlarmSetting) -> {
            if (!newAlarmSetting.equals(this.alarmSettingMap.get(name))) {
                GRPCClient grpcClient = this.grpcClientMap.get(name);
                if (grpcClient != null) {
                    grpcClient.shutdown();
                    this.grpcClientMap.remove(name);
                    this.alarmServiceStubMap.remove(name);
                    log.debug("gRPC alarm hook target is changed, shutdown the old gRPC client.");
                }
                if (newAlarmSetting.isEmptySetting()) {
                    return;
                }
                grpcClient = new GRPCClient(newAlarmSetting.getTargetHost(), newAlarmSetting.getTargetPort());
                grpcClient.connect();
                this.grpcClientMap.put((String)name, grpcClient);
                this.alarmServiceStubMap.put((String)name, AlarmServiceGrpc.newStub((Channel)grpcClient.getChannel()));
            }
        });
    }
}

