/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.datacarrier.consumer;

import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.Channels;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.QueueBuffer;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;

public class MultipleChannelsConsumer
extends Thread {
    private volatile boolean running;
    private volatile ArrayList<Group> consumeTargets = new ArrayList();
    private volatile long size;
    private final long consumeCycle;

    public MultipleChannelsConsumer(String threadName, long consumeCycle) {
        super(threadName);
        this.consumeCycle = consumeCycle;
    }

    @Override
    public void run() {
        this.running = true;
        ArrayList consumeList = new ArrayList(2000);
        while (this.running) {
            boolean hasData = false;
            for (Group target : this.consumeTargets) {
                boolean consumed = this.consume(target, consumeList);
                hasData = hasData || consumed;
            }
            if (hasData) continue;
            try {
                Thread.sleep(this.consumeCycle);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (Group target : this.consumeTargets) {
            this.consume(target, consumeList);
            target.consumer.onExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean consume(Group target, List consumeList) {
        for (int i = 0; i < target.channels.getChannelSize(); ++i) {
            QueueBuffer buffer = target.channels.getBuffer(i);
            buffer.obtain(consumeList);
        }
        if (!consumeList.isEmpty()) {
            try {
                target.consumer.consume(consumeList);
            }
            catch (Throwable t) {
                target.consumer.onError(consumeList, t);
            }
            finally {
                consumeList.clear();
            }
            return true;
        }
        target.consumer.nothingToConsume();
        return false;
    }

    public void addNewTarget(Channels channels, IConsumer consumer) {
        Group group = new Group(channels, consumer);
        ArrayList<Group> newList = new ArrayList<Group>();
        for (Group target : this.consumeTargets) {
            newList.add(target);
        }
        newList.add(group);
        this.consumeTargets = newList;
        this.size += channels.size();
    }

    public long size() {
        return this.size;
    }

    void shutdown() {
        this.running = false;
    }

    private static class Group {
        private Channels channels;
        private IConsumer consumer;

        public Group(Channels channels, IConsumer consumer) {
            this.channels = channels;
            this.consumer = consumer;
        }
    }
}

