/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.property.v1;

import com.google.protobuf.GeneratedMessageV3;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.List;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;

public class BanyandbPropertyValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(BanyandbProperty.Property.class)) {
            return new PropertyValidator();
        }
        if (clazz.equals(BanyandbProperty.ApplyRequest.class)) {
            return new ApplyRequestValidator();
        }
        if (clazz.equals(BanyandbProperty.ApplyResponse.class)) {
            return new ApplyResponseValidator();
        }
        if (clazz.equals(BanyandbProperty.DeleteRequest.class)) {
            return new DeleteRequestValidator();
        }
        if (clazz.equals(BanyandbProperty.DeleteResponse.class)) {
            return new DeleteResponseValidator();
        }
        if (clazz.equals(BanyandbProperty.QueryRequest.class)) {
            return new QueryRequestValidator();
        }
        if (clazz.equals(BanyandbProperty.QueryResponse.class)) {
            return new QueryResponseValidator();
        }
        return null;
    }

    public static class QueryResponseValidator
    implements ValidatorImpl<BanyandbProperty.QueryResponse> {
        public void assertValid(BanyandbProperty.QueryResponse proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getPropertiesList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasTrace()) {
                index.validatorFor((Object)proto.getTrace()).assertValid((Object)proto.getTrace());
            }
        }
    }

    public static class QueryRequestValidator
    implements ValidatorImpl<BanyandbProperty.QueryRequest> {
        public void assertValid(BanyandbProperty.QueryRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".banyandb.property.v1.QueryRequest.groups", (List)proto.getGroupsList(), (int)1);
            RepeatedValidation.forEach((List)proto.getGroupsList(), item -> {});
            RepeatedValidation.forEach((List)proto.getIdsList(), item -> {});
            if (proto.hasCriteria()) {
                index.validatorFor((Object)proto.getCriteria()).assertValid((Object)proto.getCriteria());
            }
            RepeatedValidation.forEach((List)proto.getTagProjectionList(), item -> {});
        }
    }

    public static class DeleteResponseValidator
    implements ValidatorImpl<BanyandbProperty.DeleteResponse> {
        public void assertValid(BanyandbProperty.DeleteResponse proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class DeleteRequestValidator
    implements ValidatorImpl<BanyandbProperty.DeleteRequest> {
        public void assertValid(BanyandbProperty.DeleteRequest proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".banyandb.property.v1.DeleteRequest.group", (String)proto.getGroup(), (int)1);
            StringValidation.minLength((String)".banyandb.property.v1.DeleteRequest.name", (String)proto.getName(), (int)1);
        }
    }

    public static class ApplyResponseValidator
    implements ValidatorImpl<BanyandbProperty.ApplyResponse> {
        public void assertValid(BanyandbProperty.ApplyResponse proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class ApplyRequestValidator
    implements ValidatorImpl<BanyandbProperty.ApplyRequest> {
        public void assertValid(BanyandbProperty.ApplyRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasProperty()) {
                RequiredValidation.required((String)".banyandb.property.v1.ApplyRequest.property", (GeneratedMessageV3)proto.getProperty());
            } else {
                RequiredValidation.required((String)".banyandb.property.v1.ApplyRequest.property", null);
            }
            if (proto.hasProperty()) {
                index.validatorFor((Object)proto.getProperty()).assertValid((Object)proto.getProperty());
            }
        }
    }

    public static class PropertyValidator
    implements ValidatorImpl<BanyandbProperty.Property> {
        public void assertValid(BanyandbProperty.Property proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasMetadata()) {
                RequiredValidation.required((String)".banyandb.property.v1.Property.metadata", (GeneratedMessageV3)proto.getMetadata());
            } else {
                RequiredValidation.required((String)".banyandb.property.v1.Property.metadata", null);
            }
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            StringValidation.minLength((String)".banyandb.property.v1.Property.id", (String)proto.getId(), (int)1);
            RepeatedValidation.minItems((String)".banyandb.property.v1.Property.tags", proto.getTagsList(), (int)1);
            RepeatedValidation.forEach(proto.getTagsList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasUpdatedAt()) {
                index.validatorFor((Object)proto.getUpdatedAt()).assertValid((Object)proto.getUpdatedAt());
            }
        }
    }
}

