/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.util;

import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class TimeUtils {
    public static ZonedDateTime parseTimestamp(Timestamp ts) {
        return Instant.ofEpochSecond(ts.getSeconds(), ts.getNanos()).atZone(ZoneId.systemDefault());
    }

    public static Timestamp buildTimestamp(ZonedDateTime zdt) {
        if (zdt == null) {
            return null;
        }
        return Timestamp.newBuilder().setSeconds(zdt.toInstant().getEpochSecond()).setNanos(zdt.toInstant().getNano()).build();
    }

    public static Timestamp fromEpochNanos(long nanos) {
        long seconds = nanos / 1000000000L;
        int nanosInt = (int)(nanos - seconds * 1000000000L);
        int res = nanosInt % 1000000;
        return Timestamp.newBuilder().setSeconds(seconds).setNanos(nanosInt - res).build();
    }
}

