/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.debug;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.query.debug.StatusQueryExceptionHandler;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmModuleProvider;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.RunningRule;
import org.apache.skywalking.oap.server.core.analysis.metrics.DoubleValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExceptionHandler(value=StatusQueryExceptionHandler.class)
public class AlarmStatusQueryHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmStatusQueryHandler.class);
    private final Gson gson = new Gson();
    private final ModuleManager moduleManager;
    private AlarmRulesWatcher alarmRulesWatcher;

    public AlarmStatusQueryHandler(ModuleManager manager) {
        this.moduleManager = manager;
    }

    private AlarmRulesWatcher getAlarmRulesWatcher() {
        if (this.alarmRulesWatcher == null) {
            AlarmModuleProvider provider = (AlarmModuleProvider)this.moduleManager.find("alarm").provider();
            this.alarmRulesWatcher = provider.getAlarmRulesWatcher();
        }
        return this.alarmRulesWatcher;
    }

    @Get(value="/status/alarm/rules")
    public HttpResponse getAlarmRules() {
        Map<String, RunningRule> runningRules = this.getAlarmRulesWatcher().getRunningContext().values().stream().map(Collection::stream).flatMap(r -> r).collect(Collectors.toMap(RunningRule::getRuleName, r -> r));
        JsonObject runningRuleNames = new JsonObject();
        JsonArray nameList = new JsonArray();
        runningRuleNames.add("ruleNames", (JsonElement)nameList);
        runningRules.keySet().forEach(arg_0 -> ((JsonArray)nameList).add(arg_0));
        return HttpResponse.of((MediaType)MediaType.JSON_UTF_8, (String)this.gson.toJson((JsonElement)runningRuleNames));
    }

    @Get(value="/status/alarm/{ruleName}")
    public HttpResponse getAlarmRuleByName(@Param(value="ruleName") String ruleName) {
        Map<String, RunningRule> runningRules = this.getAlarmRulesWatcher().getRunningContext().values().stream().flatMap(Collection::stream).collect(Collectors.toMap(RunningRule::getRuleName, r -> r));
        RunningRule rule = runningRules.get(ruleName);
        JsonObject runningRuleInfo = new JsonObject();
        runningRuleInfo.addProperty("ruleName", rule.getRuleName());
        runningRuleInfo.addProperty("expression", rule.getExpression());
        runningRuleInfo.addProperty("period", (Number)rule.getPeriod());
        runningRuleInfo.addProperty("silentPeriod", (Number)rule.getSilencePeriod());
        runningRuleInfo.addProperty("additonalPeriod", (Number)rule.getAdditionalPeriod());
        JsonArray includeNameList = new JsonArray();
        runningRuleInfo.add("includeNames", (JsonElement)includeNameList);
        rule.getIncludeNames().forEach(arg_0 -> ((JsonArray)includeNameList).add(arg_0));
        JsonArray excludeNameList = new JsonArray();
        runningRuleInfo.add("excludeNames", (JsonElement)excludeNameList);
        rule.getExcludeNames().forEach(arg_0 -> ((JsonArray)excludeNameList).add(arg_0));
        runningRuleInfo.addProperty("includeNamesRegex", rule.getExcludeNamesRegex() == null ? "" : rule.getIncludeNamesRegex().toString());
        runningRuleInfo.addProperty("excludeNamesRegex", rule.getExcludeNamesRegex() == null ? "" : rule.getExcludeNamesRegex().toString());
        JsonArray affectedEntities = new JsonArray();
        runningRuleInfo.add("affectedEntities", (JsonElement)affectedEntities);
        JsonArray msgFormatter = new JsonArray();
        rule.getWindows().keySet().forEach(e -> {
            JsonObject entity = new JsonObject();
            entity.addProperty("scope", e.getScope());
            entity.addProperty("name", e.getName());
            affectedEntities.add((JsonElement)entity);
            JsonObject msg = new JsonObject();
            msg.addProperty(e.getName(), rule.getFormatter().format(e));
            msgFormatter.add((JsonElement)msg);
        });
        JsonArray tagList = new JsonArray();
        runningRuleInfo.add("tags", (JsonElement)tagList);
        rule.getTags().forEach(tag -> {
            JsonObject tagInfo = new JsonObject();
            tagInfo.addProperty("key", tag.getKey());
            tagInfo.addProperty("value", tag.getValue());
            tagList.add((JsonElement)tagInfo);
        });
        JsonArray hookList = new JsonArray();
        runningRuleInfo.add("hooks", (JsonElement)hookList);
        rule.getHooks().forEach(arg_0 -> ((JsonArray)hookList).add(arg_0));
        JsonArray includeMetricList = new JsonArray();
        runningRuleInfo.add("includeMetrics", (JsonElement)includeMetricList);
        rule.getIncludeMetrics().forEach(arg_0 -> ((JsonArray)includeMetricList).add(arg_0));
        runningRuleInfo.add("formattedMessages", (JsonElement)msgFormatter);
        return HttpResponse.of((MediaType)MediaType.JSON_UTF_8, (String)runningRuleInfo.toString());
    }

    @Get(value="/status/alarm/{ruleName}/{entityName}")
    public HttpResponse getAlarmRuleContext(@Param(value="ruleName") String ruleName, @Param(value="entityName") String entityName) {
        Map<String, RunningRule> runningRules = this.getAlarmRulesWatcher().getRunningContext().values().stream().flatMap(Collection::stream).collect(Collectors.toMap(RunningRule::getRuleName, r -> r));
        RunningRule rule = runningRules.get(ruleName);
        Map windows = rule.getWindows();
        RunningRule.Window window = windows.keySet().stream().filter(e -> e.getName().equals(entityName)).map(windows::get).findFirst().orElse(null);
        JsonObject runningContext = new JsonObject();
        if (window == null) {
            return HttpResponse.of((MediaType)MediaType.JSON_UTF_8, (String)runningContext.toString());
        }
        runningContext.addProperty("expression", rule.getExpression());
        runningContext.addProperty("endTime", window.getEndTime().toString());
        runningContext.addProperty("additionalPeriod", (Number)window.getAdditionalPeriod());
        runningContext.addProperty("size", (Number)window.getSize());
        runningContext.addProperty("silenceCountdown", (Number)window.getSilenceCountdown());
        JsonArray metricValues = new JsonArray();
        runningContext.add("windowValues", (JsonElement)metricValues);
        window.scanWindowValues(values -> {
            for (int i = 0; i < values.size(); ++i) {
                JsonObject index = new JsonObject();
                JsonArray metrics = new JsonArray();
                metricValues.add((JsonElement)index);
                index.addProperty("index", (Number)i);
                index.add("metrics", (JsonElement)metrics);
                Map m = (Map)values.get(i);
                if (null == m) continue;
                m.forEach((name, metric) -> {
                    JsonObject metricValue = new JsonObject();
                    metricValue.addProperty("timeBucket", (Number)metric.getTimeBucket());
                    metricValue.addProperty("name", name);
                    String value = "";
                    if (metric instanceof LongValueHolder) {
                        value = Long.toString(((LongValueHolder)metric).getValue());
                    } else if (metric instanceof IntValueHolder) {
                        value = Integer.toString(((IntValueHolder)metric).getValue());
                    } else if (metric instanceof DoubleValueHolder) {
                        value = Double.toString(((DoubleValueHolder)metric).getValue());
                    } else if (metric instanceof LabeledValueHolder) {
                        value = ((LabeledValueHolder)metric).getValue().toString();
                    }
                    metricValue.addProperty("value", value);
                    metrics.add((JsonElement)metricValue);
                });
            }
        });
        runningContext.add("mqeMetricsSnapshot", (JsonElement)window.getMqeMetricsSnapshot());
        return HttpResponse.of((MediaType)MediaType.JSON_UTF_8, (String)this.gson.toJson((JsonElement)runningContext));
    }
}

