/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.execution.DataFetcherResult;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class GraphqlErrorBuilder<B extends GraphqlErrorBuilder<B>>
implements GraphQLError.Builder<B> {
    private String message;
    private List<Object> path;
    private List<SourceLocation> locations = new ArrayList<SourceLocation>();
    private ErrorClassification errorType = ErrorType.DataFetchingException;
    private Map<String, Object> extensions = null;

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public List<Object> getPath() {
        return this.path;
    }

    @Nullable
    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    public ErrorClassification getErrorType() {
        return this.errorType;
    }

    @Nullable
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public static GraphqlErrorBuilder<?> newError() {
        return new GraphqlErrorBuilder();
    }

    public static GraphqlErrorBuilder<?> newError(DataFetchingEnvironment dataFetchingEnvironment) {
        return ((GraphqlErrorBuilder)new GraphqlErrorBuilder().location(dataFetchingEnvironment.getField().getSourceLocation())).path(dataFetchingEnvironment.getExecutionStepInfo().getPath());
    }

    protected GraphqlErrorBuilder() {
    }

    @Override
    public B message(String message, Object ... formatArgs) {
        this.message = formatArgs == null || formatArgs.length == 0 ? Assert.assertNotNull(message) : String.format(Assert.assertNotNull(message), formatArgs);
        return (B)this;
    }

    @Override
    public B locations(@Nullable List<SourceLocation> locations) {
        if (locations != null) {
            this.locations.addAll(locations);
        } else {
            this.locations = null;
        }
        return (B)this;
    }

    @Override
    public B location(@Nullable SourceLocation location) {
        if (this.locations != null) {
            this.locations.add(location);
        }
        return (B)this;
    }

    @Override
    public B path(@Nullable ResultPath path) {
        this.path = path != null ? path.toList() : null;
        return (B)this;
    }

    @Override
    public B path(@Nullable List<Object> path) {
        this.path = path;
        return (B)this;
    }

    @Override
    public B errorType(ErrorClassification errorType) {
        this.errorType = Assert.assertNotNull(errorType);
        return (B)this;
    }

    @Override
    public B extensions(@Nullable Map<String, Object> extensions) {
        this.extensions = extensions;
        return (B)this;
    }

    @Override
    public GraphQLError build() {
        Assert.assertNotNull(this.message, () -> "You must provide error message");
        return new GraphqlErrorImpl(this.message, this.locations, this.errorType, this.path, this.extensions);
    }

    public DataFetcherResult<?> toResult() {
        return DataFetcherResult.newResult().error(this.build()).build();
    }

    private static class GraphqlErrorImpl
    implements GraphQLError {
        private final String message;
        private final List<SourceLocation> locations;
        private final ErrorClassification errorType;
        private final List<Object> path;
        private final Map<String, Object> extensions;

        public GraphqlErrorImpl(String message, List<SourceLocation> locations, ErrorClassification errorType, List<Object> path, Map<String, Object> extensions) {
            this.message = message;
            this.locations = locations;
            this.errorType = errorType;
            this.path = path;
            this.extensions = extensions;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public List<SourceLocation> getLocations() {
            return this.locations;
        }

        @Override
        public ErrorClassification getErrorType() {
            return this.errorType;
        }

        @Override
        public List<Object> getPath() {
            return this.path;
        }

        @Override
        public Map<String, Object> getExtensions() {
            return this.extensions;
        }

        public String toString() {
            return this.message;
        }
    }
}

