/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigInteger;
import java.util.Locale;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class GraphqlIDCoercing
implements Coercing<Object, Object> {
    private String convertImpl(Object input) {
        if (input instanceof String) {
            return (String)input;
        }
        if (input instanceof Integer) {
            return String.valueOf(input);
        }
        if (input instanceof Long) {
            return String.valueOf(input);
        }
        if (input instanceof UUID) {
            return String.valueOf(input);
        }
        if (input instanceof BigInteger) {
            return String.valueOf(input);
        }
        return String.valueOf(input);
    }

    @NotNull
    private String serializeImpl(Object input, @NotNull Locale locale) {
        String result = String.valueOf(input);
        if (result == null) {
            throw new CoercingSerializeException("Expected type 'ID' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        return result;
    }

    @NotNull
    private String parseValueImpl(Object input, @NotNull Locale locale) {
        String result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "ID.notId", CoercingUtil.typeName(input)));
        }
        return result;
    }

    private String parseLiteralImpl(Object input, @NotNull Locale locale) {
        if (input instanceof StringValue) {
            return ((StringValue)input).getValue();
        }
        if (input instanceof IntValue) {
            return ((IntValue)input).getValue().toString();
        }
        throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "ID.unexpectedAstType", CoercingUtil.typeName(input)));
    }

    @NotNull
    private StringValue valueToLiteralImpl(Object input, @NotNull Locale locale) {
        String result = Assert.assertNotNull(this.convertImpl(input), () -> CoercingUtil.i18nMsg(locale, "ID.notId", CoercingUtil.typeName(input)));
        return StringValue.newStringValue(result).build();
    }

    @Override
    @Deprecated
    public String serialize(@NotNull Object dataFetcherResult) {
        return this.serializeImpl(dataFetcherResult, Locale.getDefault());
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object dataFetcherResult, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingSerializeException {
        return this.serializeImpl(dataFetcherResult, locale);
    }

    @Override
    @Deprecated
    public String parseValue(@NotNull Object input) {
        return this.parseValueImpl(input, Locale.getDefault());
    }

    @Override
    public Object parseValue(@NotNull Object input, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingParseValueException {
        return this.parseValueImpl(input, locale);
    }

    @Override
    @Deprecated
    public String parseLiteral(@NotNull Object input) {
        return this.parseLiteralImpl(input, Locale.getDefault());
    }

    @Override
    @Nullable
    public Object parseLiteral(@NotNull Value<?> input, @NotNull CoercedVariables variables, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingParseLiteralException {
        return this.parseLiteralImpl(input, locale);
    }

    @Override
    @Deprecated
    public Value valueToLiteral(@NotNull Object input) {
        return this.valueToLiteralImpl(input, Locale.getDefault());
    }

    @Override
    @NotNull
    public Value<?> valueToLiteral(@NotNull Object input, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) {
        return this.valueToLiteralImpl(input, locale);
    }
}

