/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.ExperimentalApi;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidationErrorCollector;
import graphql.schema.validation.SchemaValidationErrorType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;

@ExperimentalApi
public class OneOfInputObjectRules
extends GraphQLTypeVisitorStub {
    @Override
    public TraversalControl visitGraphQLInputObjectField(GraphQLInputObjectField inputObjectField, TraverserContext<GraphQLSchemaElement> context) {
        String message;
        GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)context.getParentNode();
        if (!inputObjectType.isOneOf()) {
            return TraversalControl.CONTINUE;
        }
        SchemaValidationErrorCollector errorCollector = context.getVarFromParents(SchemaValidationErrorCollector.class);
        if (inputObjectField.hasSetDefaultValue()) {
            message = String.format("OneOf input field %s.%s cannot have a default value.", inputObjectType.getName(), inputObjectField.getName());
            errorCollector.addError(new SchemaValidationError(SchemaValidationErrorType.OneOfDefaultValueOnField, message));
        }
        if (GraphQLTypeUtil.isNonNull(inputObjectField.getType())) {
            message = String.format("OneOf input field %s.%s must be nullable.", inputObjectType.getName(), inputObjectField.getName());
            errorCollector.addError(new SchemaValidationError(SchemaValidationErrorType.OneOfNonNullableField, message));
        }
        return TraversalControl.CONTINUE;
    }
}

