/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.dsl.tagOpt;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.meter.analyzer.dsl.Sample;
import org.apache.skywalking.oap.meter.analyzer.dsl.tagOpt.Retag;
import org.apache.skywalking.oap.meter.analyzer.k8s.K8sInfoRegistry;

public enum K8sRetagType implements Retag
{
    Pod2Service{

        @Override
        public Sample[] execute(Sample[] ss, String newLabelName, String existingLabelName, String namespaceLabelName) {
            return (Sample[])Arrays.stream(ss).map(sample -> {
                String podName = (String)sample.getLabels().get((Object)existingLabelName);
                String namespace = (String)sample.getLabels().get((Object)namespaceLabelName);
                if (!Strings.isNullOrEmpty((String)podName) && !Strings.isNullOrEmpty((String)namespace)) {
                    String serviceName = K8sInfoRegistry.getInstance().findServiceName(namespace, podName);
                    if (Strings.isNullOrEmpty((String)serviceName)) {
                        serviceName = "";
                    }
                    HashMap labels = Maps.newHashMap(sample.getLabels());
                    labels.put(newLabelName, serviceName);
                    return sample.toBuilder().labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)labels)).build();
                }
                return sample;
            }).toArray(Sample[]::new);
        }
    };

}

