/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.numeric;

import graphql.Internal;
import graphql.scalars.numeric.IntCoercing;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.util.function.Function;

@Internal
public final class NonNegativeIntScalar {
    public static final GraphQLScalarType INSTANCE = GraphQLScalarType.newScalar().name("NonNegativeInt").description("An Int scalar that must be greater than or equal to zero").coercing((Coercing)new IntCoercing(){

        @Override
        protected Integer check(Integer i, Function<String, RuntimeException> exceptionMaker) {
            if (i < 0) {
                throw exceptionMaker.apply("The value must be greater than or equal to zero");
            }
            return i;
        }
    }).build();

    private NonNegativeIntScalar() {
    }
}

