/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.internals.ConfigManager;
import com.ctrip.framework.apollo.spi.ConfigFactory;
import com.ctrip.framework.apollo.spi.ConfigFactoryManager;
import com.google.common.collect.Maps;
import java.util.Map;

public class DefaultConfigManager
implements ConfigManager {
    private ConfigFactoryManager m_factoryManager;
    private Map<String, Config> m_configs = Maps.newConcurrentMap();
    private Map<String, ConfigFile> m_configFiles = Maps.newConcurrentMap();

    public DefaultConfigManager() {
        this.m_factoryManager = ApolloInjector.getInstance(ConfigFactoryManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Config getConfig(String namespace) {
        Config config = this.m_configs.get(namespace);
        if (config == null) {
            DefaultConfigManager defaultConfigManager = this;
            synchronized (defaultConfigManager) {
                config = this.m_configs.get(namespace);
                if (config == null) {
                    ConfigFactory factory = this.m_factoryManager.getFactory(namespace);
                    config = factory.create(namespace);
                    this.m_configs.put(namespace, config);
                }
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigFile getConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        String namespaceFileName = String.format("%s.%s", namespace, configFileFormat.getValue());
        ConfigFile configFile = this.m_configFiles.get(namespaceFileName);
        if (configFile == null) {
            DefaultConfigManager defaultConfigManager = this;
            synchronized (defaultConfigManager) {
                configFile = this.m_configFiles.get(namespaceFileName);
                if (configFile == null) {
                    ConfigFactory factory = this.m_factoryManager.getFactory(namespaceFileName);
                    configFile = factory.createConfigFile(namespaceFileName, configFileFormat);
                    this.m_configFiles.put(namespaceFileName, configFile);
                }
            }
        }
        return configFile;
    }
}

