/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.google.gson.JsonObject;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureWrite;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamWrite;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.Serializable;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBConverter {
    public static final String ID = "id";

    private static Serializable<BanyandbModel.TagValue> buildTag(Object value, Class<?> clazz) {
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return TagAndValue.longTagValue((Long)((Number)value).longValue());
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return TagAndValue.longTagValue((Long)((Long)value));
        }
        if (String.class.equals(clazz)) {
            return TagAndValue.stringTagValue((String)((String)value));
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return TagAndValue.binaryTagValue((byte[])ByteUtil.double2Bytes((Double)value));
        }
        if (StorageDataComplexObject.class.isAssignableFrom(clazz)) {
            return TagAndValue.stringTagValue((String)((StorageDataComplexObject)value).toStorageData());
        }
        if (Layer.class.equals(clazz)) {
            return TagAndValue.longTagValue((Long)((Integer)value).longValue());
        }
        if (JsonObject.class.equals(clazz)) {
            return TagAndValue.stringTagValue((String)((String)value));
        }
        if (byte[].class.equals(clazz)) {
            return TagAndValue.stringTagValue((String)((String)value));
        }
        throw new IllegalStateException(clazz.getSimpleName() + " is not supported");
    }

    private static Serializable<BanyandbModel.FieldValue> buildField(Object value, Class<?> clazz) {
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return TagAndValue.longFieldValue((long)((Number)value).longValue());
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return TagAndValue.longFieldValue((long)((Long)value));
        }
        if (String.class.equals(clazz)) {
            return TagAndValue.stringFieldValue((String)((String)value));
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return TagAndValue.binaryFieldValue((byte[])ByteUtil.double2Bytes((Double)value));
        }
        if (StorageDataComplexObject.class.isAssignableFrom(clazz)) {
            return TagAndValue.stringFieldValue((String)((StorageDataComplexObject)value).toStorageData());
        }
        throw new IllegalStateException(clazz.getSimpleName() + " is not supported");
    }

    public static class StorageToMeasure
    implements Convert2Entity {
        private final MetadataRegistry.Schema schema;
        private final DataPoint dataPoint;

        public StorageToMeasure(MetadataRegistry.Schema schema, DataPoint dataPoint) {
            this.schema = schema;
            this.dataPoint = dataPoint;
        }

        public Object get(String fieldName) {
            if (fieldName.equals("time_bucket")) {
                return TimeBucket.getTimeBucket((long)this.dataPoint.getTimestamp(), (DownSampling)this.schema.getMetadata().getDownSampling());
            }
            MetadataRegistry.ColumnSpec spec = this.schema.getSpec(fieldName);
            Class<?> clazz = spec.getColumnClass();
            switch (spec.getColumnType()) {
                case TAG: {
                    Object tv = this.dataPoint.getTagValue(fieldName);
                    if (tv == null) {
                        return this.defaultValue(clazz);
                    }
                    if (Double.TYPE.equals(clazz)) {
                        return ByteUtil.bytes2Double((byte[])this.dataPoint.getTagValue(fieldName));
                    }
                    return this.dataPoint.getTagValue(fieldName);
                }
            }
            Object fv = this.dataPoint.getFieldValue(fieldName);
            if (fv == null) {
                return this.defaultValue(clazz);
            }
            if (Double.TYPE.equals(spec.getColumnClass())) {
                return ByteUtil.bytes2Double((byte[])this.dataPoint.getFieldValue(fieldName));
            }
            return this.dataPoint.getFieldValue(fieldName);
        }

        public byte[] getBytes(String fieldName) {
            return (byte[])this.dataPoint.getFieldValue(fieldName);
        }

        private Object defaultValue(Class<?> clazz) {
            if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
                return 0;
            }
            if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
                return 0L;
            }
            if (String.class.equals(clazz)) {
                return "";
            }
            if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
                return 0.0;
            }
            if (StorageDataComplexObject.class.isAssignableFrom(clazz)) {
                return "";
            }
            if (JsonObject.class.equals(clazz)) {
                return "";
            }
            if (byte[].class.equals(clazz)) {
                return new byte[0];
            }
            throw new IllegalStateException(clazz.getSimpleName() + " is not supported");
        }
    }

    public static class MeasureToStorage
    implements Convert2Storage<MeasureWrite> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(MeasureToStorage.class);
        private final MetadataRegistry.Schema schema;
        private final MeasureWrite measureWrite;

        public void accept(String fieldName, Object fieldValue) {
            if (fieldName.equals("time_bucket")) {
                return;
            }
            MetadataRegistry.ColumnSpec columnSpec = this.schema.getSpec(fieldName);
            if (columnSpec == null) {
                throw new IllegalArgumentException("fail to find tag/field[" + fieldName + "]");
            }
            try {
                if (columnSpec.getColumnType() == MetadataRegistry.ColumnType.TAG) {
                    this.measureWrite.tag(fieldName, BanyanDBConverter.buildTag(fieldValue, columnSpec.getColumnClass()));
                } else {
                    this.measureWrite.field(fieldName, BanyanDBConverter.buildField(fieldValue, columnSpec.getColumnClass()));
                }
            }
            catch (BanyanDBException ex) {
                log.error("fail to add tag/field", (Throwable)ex);
            }
        }

        public void acceptID(String id) {
            try {
                this.measureWrite.tag(BanyanDBConverter.ID, TagAndValue.stringTagValue((String)id));
            }
            catch (BanyanDBException ex) {
                log.error("fail to add ID tag", (Throwable)ex);
            }
        }

        public void accept(String fieldName, byte[] fieldValue) {
            MetadataRegistry.ColumnSpec columnSpec = this.schema.getSpec(fieldName);
            try {
                if (columnSpec.getColumnType() == MetadataRegistry.ColumnType.TAG) {
                    this.measureWrite.tag(fieldName, TagAndValue.binaryTagValue((byte[])fieldValue));
                } else {
                    this.measureWrite.field(fieldName, TagAndValue.binaryFieldValue((byte[])fieldValue));
                }
            }
            catch (BanyanDBException ex) {
                log.error("fail to add binary tag/field", (Throwable)ex);
            }
        }

        public void accept(String fieldName, List<String> fieldValue) {
            try {
                this.measureWrite.tag(fieldName, TagAndValue.stringArrayTagValue(fieldValue));
            }
            catch (BanyanDBException ex) {
                log.error("fail to accept string array tag", (Throwable)ex);
            }
        }

        public Object get(String fieldName) {
            throw new IllegalStateException("should not reach here");
        }

        public MeasureWrite obtain() {
            return this.measureWrite;
        }

        @Generated
        public MeasureToStorage(MetadataRegistry.Schema schema, MeasureWrite measureWrite) {
            this.schema = schema;
            this.measureWrite = measureWrite;
        }
    }

    public static class StreamToStorage
    implements Convert2Storage<StreamWrite> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(StreamToStorage.class);
        private final MetadataRegistry.Schema schema;
        private final StreamWrite streamWrite;

        public void accept(String fieldName, Object fieldValue) {
            MetadataRegistry.ColumnSpec columnSpec;
            if (fieldName.equals("time_bucket")) {
                return;
            }
            if (fieldName.equals(this.schema.getTimestampColumn4Stream())) {
                this.streamWrite.setTimestamp(((Long)fieldValue).longValue());
            }
            if ((columnSpec = this.schema.getSpec(fieldName)) == null) {
                throw new IllegalArgumentException("fail to find tag[" + fieldName + "]");
            }
            if (columnSpec.getColumnType() != MetadataRegistry.ColumnType.TAG) {
                throw new IllegalArgumentException("ColumnType other than TAG is not supported for Stream, it should be an internal error, please submit an issue to the SkyWalking community");
            }
            try {
                this.streamWrite.tag(fieldName, BanyanDBConverter.buildTag(fieldValue, columnSpec.getColumnClass()));
            }
            catch (BanyanDBException ex) {
                log.error("fail to add tag", (Throwable)ex);
            }
        }

        public void accept(String fieldName, byte[] fieldValue) {
            try {
                this.streamWrite.tag(fieldName, TagAndValue.binaryTagValue((byte[])fieldValue));
            }
            catch (BanyanDBException ex) {
                log.error("fail to add tag", (Throwable)ex);
            }
        }

        public void accept(String fieldName, List<String> fieldValue) {
            try {
                this.streamWrite.tag(fieldName, TagAndValue.stringArrayTagValue(fieldValue));
            }
            catch (BanyanDBException ex) {
                log.error("fail to accept string array tag", (Throwable)ex);
            }
        }

        public Object get(String fieldName) {
            throw new IllegalStateException("should not reach here");
        }

        public StreamWrite obtain() {
            return this.streamWrite;
        }

        @Generated
        public StreamToStorage(MetadataRegistry.Schema schema, StreamWrite streamWrite) {
            this.schema = schema;
            this.streamWrite = streamWrite;
        }
    }

    public static class StorageToStream
    implements Convert2Entity {
        private final MetadataRegistry.Schema schema;
        private final RowEntity rowEntity;

        public StorageToStream(String streamModelName, RowEntity rowEntity) {
            this.schema = MetadataRegistry.INSTANCE.findRecordMetadata(streamModelName);
            this.rowEntity = rowEntity;
        }

        public Object get(String fieldName) {
            if (fieldName.equals("time_bucket")) {
                String timestampColumnName = this.schema.getTimestampColumn4Stream();
                long timestampMillis = ((Number)this.get(timestampColumnName)).longValue();
                return TimeBucket.getTimeBucket((long)timestampMillis, (DownSampling)this.schema.getMetadata().getDownSampling());
            }
            MetadataRegistry.ColumnSpec spec = this.schema.getSpec(fieldName);
            if (Double.TYPE.equals(spec.getColumnClass())) {
                return ByteUtil.bytes2Double((byte[])this.rowEntity.getTagValue(fieldName));
            }
            return this.rowEntity.getTagValue(fieldName);
        }

        public byte[] getBytes(String fieldName) {
            return (byte[])this.rowEntity.getTagValue(fieldName);
        }
    }
}

