/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.google.gson.JsonObject;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.metadata.Duration;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.config.DownSamplingConfigService;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MeasureModel;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.PropertyModel;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.StreamModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MetadataRegistry {
    INSTANCE;

    @Generated
    private static final Logger log;
    private final Map<String, Schema> registry = new HashMap<String, Schema>();

    public StreamModel registerStreamModel(Model model, BanyanDBStorageConfig config, DownSamplingConfigService configService) {
        SchemaMetadata schemaMetadata = this.parseMetadata(model, config, configService);
        Schema.SchemaBuilder schemaBuilder = Schema.builder().metadata(schemaMetadata);
        Map<String, ModelColumn> modelColumnMap = model.getColumns().stream().collect(Collectors.toMap(modelColumn -> modelColumn.getColumnName().getStorageName(), Function.identity()));
        List<String> seriesIDColumns = this.parseEntityNames(modelColumnMap);
        if (seriesIDColumns.isEmpty()) {
            throw new IllegalStateException("seriesID of model[stream." + model.getName() + "] must not be empty");
        }
        List<TagMetadata> tags = this.parseTagMetadata(model, schemaBuilder, seriesIDColumns, schemaMetadata.group);
        List<BanyandbDatabase.TagFamilySpec> tagFamilySpecs = schemaMetadata.extractTagFamilySpec(tags, false);
        for (BanyandbDatabase.TagFamilySpec tagFamilySpec : tagFamilySpecs) {
            for (BanyandbDatabase.TagSpec tagSpec : tagFamilySpec.getTagsList()) {
                schemaBuilder.tag(tagSpec.getName());
            }
        }
        String timestampColumn4Stream = model.getBanyanDBModelExtension().getTimestampColumn();
        if (StringUtil.isBlank((String)timestampColumn4Stream)) {
            throw new IllegalStateException("Model[stream." + model.getName() + "] miss defined @BanyanDB.TimestampColumn");
        }
        schemaBuilder.timestampColumn4Stream(timestampColumn4Stream);
        List<BanyandbDatabase.IndexRule> indexRules = tags.stream().map(TagMetadata::getIndexRule).filter(Objects::nonNull).collect(Collectors.toList());
        BanyandbDatabase.Stream.Builder builder = BanyandbDatabase.Stream.newBuilder();
        builder.setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(schemaMetadata.getGroup()).setName(schemaMetadata.name()));
        builder.setEntity(BanyandbDatabase.Entity.newBuilder().addAllTagNames(seriesIDColumns));
        builder.addAllTagFamilies(tagFamilySpecs);
        this.registry.put(schemaMetadata.name(), schemaBuilder.build());
        return new StreamModel(builder.build(), indexRules);
    }

    public MeasureModel registerMeasureModel(Model model, BanyanDBStorageConfig config, DownSamplingConfigService configService) throws StorageException {
        SchemaMetadata schemaMetadata = this.parseMetadata(model, config, configService);
        Schema.SchemaBuilder schemaBuilder = Schema.builder().metadata(schemaMetadata);
        Map<String, ModelColumn> modelColumnMap = model.getColumns().stream().collect(Collectors.toMap(modelColumn -> modelColumn.getColumnName().getStorageName(), Function.identity()));
        List<String> seriesIDColumns = this.parseEntityNames(modelColumnMap);
        if (seriesIDColumns.isEmpty()) {
            throw new StorageException("model " + model.getName() + " doesn't contain series id");
        }
        MeasureMetadata tagsAndFields = this.parseTagAndFieldMetadata(model, schemaBuilder, seriesIDColumns, schemaMetadata.group);
        List<BanyandbDatabase.TagFamilySpec> tagFamilySpecs = schemaMetadata.extractTagFamilySpec(tagsAndFields.tags, model.getBanyanDBModelExtension().isStoreIDTag());
        for (BanyandbDatabase.TagFamilySpec tagFamilySpec : tagFamilySpecs) {
            for (BanyandbDatabase.TagSpec tagSpec : tagFamilySpec.getTagsList()) {
                schemaBuilder.tag(tagSpec.getName());
            }
        }
        List<BanyandbDatabase.IndexRule> indexRules = tagsAndFields.tags.stream().map(TagMetadata::getIndexRule).filter(Objects::nonNull).collect(Collectors.toList());
        if (model.getBanyanDBModelExtension().isStoreIDTag()) {
            indexRules.add(this.indexRule(schemaMetadata.group, "id", false, null));
        }
        BanyandbDatabase.Measure.Builder builder = BanyandbDatabase.Measure.newBuilder();
        builder.setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(schemaMetadata.getGroup()).setName(schemaMetadata.name()));
        builder.setInterval(this.downSamplingDuration(model.getDownsampling()).format());
        builder.setEntity(BanyandbDatabase.Entity.newBuilder().addAllTagNames(seriesIDColumns));
        builder.addAllTagFamilies(tagFamilySpecs);
        if (model.getBanyanDBModelExtension().isIndexMode()) {
            builder.setIndexMode(true);
            if (!tagsAndFields.fields.isEmpty()) {
                throw new StorageException("index mode is enabled, but fields are defined");
            }
        }
        for (BanyandbDatabase.FieldSpec field : tagsAndFields.fields) {
            builder.addFields(field);
            schemaBuilder.field(field.getName());
        }
        schemaBuilder.topNSpec(this.parseTopNSpec(model, schemaMetadata.group, schemaMetadata.name()));
        this.registry.put(schemaMetadata.name(), schemaBuilder.build());
        return new MeasureModel(builder.build(), indexRules);
    }

    public PropertyModel registerPropertyModel(Model model, BanyanDBStorageConfig config) {
        SchemaMetadata schemaMetadata = this.parseMetadata(model, config, null);
        Schema.SchemaBuilder schemaBuilder = Schema.builder().metadata(schemaMetadata);
        List<TagMetadata> tags = this.parseTagMetadata(model, schemaBuilder, Collections.emptyList(), schemaMetadata.group);
        BanyandbDatabase.Property.Builder builder = BanyandbDatabase.Property.newBuilder();
        builder.setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(schemaMetadata.getGroup()).setName(schemaMetadata.name()));
        for (TagMetadata tag : tags) {
            builder.addTags(tag.getTagSpec());
        }
        return new PropertyModel(builder.build());
    }

    private BanyandbDatabase.TopNAggregation parseTopNSpec(Model model, String group, String measureName) throws StorageException {
        if (model.getBanyanDBModelExtension().getTopN() == null) {
            return null;
        }
        Optional valueColumnOpt = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(model.getName());
        if (valueColumnOpt.isEmpty() || ((ValueColumnMetadata.ValueColumn)valueColumnOpt.get()).getDataType() != Column.ValueDataType.COMMON_VALUE) {
            return null;
        }
        if (CollectionUtils.isEmpty((List)model.getBanyanDBModelExtension().getTopN().getGroupByTagNames())) {
            throw new StorageException("invalid groupBy tags: " + model.getBanyanDBModelExtension().getTopN().getGroupByTagNames());
        }
        return BanyandbDatabase.TopNAggregation.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(Schema.formatTopNName(measureName))).setSourceMeasure(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(measureName)).setFieldValueSort(BanyandbModel.Sort.SORT_UNSPECIFIED).setFieldName(((ValueColumnMetadata.ValueColumn)valueColumnOpt.get()).getValueCName()).addAllGroupByTagNames((Iterable)model.getBanyanDBModelExtension().getTopN().getGroupByTagNames()).setCountersNumber(model.getBanyanDBModelExtension().getTopN().getCountersNumber()).setLruSize(model.getBanyanDBModelExtension().getTopN().getLruSize()).build();
    }

    public Schema findMetadata(Model model) {
        if (model.isRecord()) {
            return this.findRecordMetadata(model.getName());
        }
        return this.findMetadata(model.getName(), model.getDownsampling());
    }

    public Schema findRecordMetadata(String recordModelName) {
        Schema s = this.registry.get(recordModelName);
        if (s == null) {
            return null;
        }
        if (s.getMetadata().getKind() != Kind.STREAM) {
            throw new IllegalArgumentException(recordModelName + "is not a record");
        }
        return s;
    }

    static DownSampling deriveFromStep(Step step) {
        switch (step) {
            case DAY: {
                return DownSampling.Day;
            }
            case HOUR: {
                return DownSampling.Hour;
            }
            case SECOND: {
                return DownSampling.Second;
            }
        }
        return DownSampling.Minute;
    }

    public Schema findMetadata(String modelName, Step step) {
        return this.findMetadata(modelName, MetadataRegistry.deriveFromStep(step));
    }

    public Schema findMetadata(String modelName, DownSampling downSampling) {
        return this.registry.get(SchemaMetadata.formatName(modelName, downSampling));
    }

    private BanyandbDatabase.FieldSpec parseFieldSpec(ModelColumn modelColumn) {
        String colName = modelColumn.getColumnName().getStorageName();
        if (String.class.equals((Object)modelColumn.getType())) {
            return BanyandbDatabase.FieldSpec.newBuilder().setName(colName).setFieldType(BanyandbDatabase.FieldType.FIELD_TYPE_STRING).setCompressionMethod(BanyandbDatabase.CompressionMethod.COMPRESSION_METHOD_ZSTD).build();
        }
        if (Long.TYPE.equals(modelColumn.getType()) || Integer.TYPE.equals(modelColumn.getType())) {
            return BanyandbDatabase.FieldSpec.newBuilder().setName(colName).setFieldType(BanyandbDatabase.FieldType.FIELD_TYPE_INT).setCompressionMethod(BanyandbDatabase.CompressionMethod.COMPRESSION_METHOD_ZSTD).setEncodingMethod(BanyandbDatabase.EncodingMethod.ENCODING_METHOD_GORILLA).build();
        }
        if (StorageDataComplexObject.class.isAssignableFrom(modelColumn.getType()) || JsonObject.class.equals((Object)modelColumn.getType())) {
            return BanyandbDatabase.FieldSpec.newBuilder().setName(colName).setFieldType(BanyandbDatabase.FieldType.FIELD_TYPE_STRING).setCompressionMethod(BanyandbDatabase.CompressionMethod.COMPRESSION_METHOD_ZSTD).build();
        }
        if (Double.TYPE.equals(modelColumn.getType())) {
            log.warn("Double is stored as binary");
            return BanyandbDatabase.FieldSpec.newBuilder().setName(colName).setFieldType(BanyandbDatabase.FieldType.FIELD_TYPE_DATA_BINARY).setCompressionMethod(BanyandbDatabase.CompressionMethod.COMPRESSION_METHOD_ZSTD).build();
        }
        throw new UnsupportedOperationException(modelColumn.getType().getSimpleName() + " is not supported for field");
    }

    Duration downSamplingDuration(DownSampling downSampling) {
        switch (downSampling) {
            case Hour: {
                return Duration.ofHours((long)1L);
            }
            case Minute: {
                return Duration.ofMinutes((long)1L);
            }
            case Day: {
                return Duration.ofHours((long)24L);
            }
        }
        throw new UnsupportedOperationException("unsupported downSampling interval");
    }

    BanyandbDatabase.IndexRule indexRule(String group, String tagName, boolean enableSort, BanyanDB.MatchQuery.AnalyzerType analyzer) {
        BanyandbDatabase.IndexRule.Builder builder = BanyandbDatabase.IndexRule.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setName(tagName).setGroup(group)).setType(BanyandbDatabase.IndexRule.Type.TYPE_INVERTED).addTags(tagName);
        builder.setNoSort(!enableSort);
        if (analyzer != null) {
            switch (analyzer) {
                case KEYWORD: {
                    builder.setAnalyzer("keyword");
                    break;
                }
                case STANDARD: {
                    builder.setAnalyzer("standard");
                    break;
                }
                case SIMPLE: {
                    builder.setAnalyzer("simple");
                    break;
                }
                case URL: {
                    builder.setAnalyzer("url");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported analyzer type: " + analyzer);
                }
            }
        }
        return builder.build();
    }

    List<String> parseEntityNames(Map<String, ModelColumn> modelColumnMap) {
        ArrayList<ModelColumn> seriesIDColumns = new ArrayList<ModelColumn>();
        for (ModelColumn col2 : modelColumnMap.values()) {
            if (!col2.getBanyanDBExtension().isSeriesID()) continue;
            seriesIDColumns.add(col2);
        }
        return seriesIDColumns.stream().sorted(Comparator.comparingInt(col -> col.getBanyanDBExtension().getSeriesIDIdx())).map(col -> col.getColumnName().getName()).collect(Collectors.toList());
    }

    List<TagMetadata> parseTagMetadata(Model model, Schema.SchemaBuilder builder, List<String> seriesIDColumns, String group) {
        ArrayList<TagMetadata> tagMetadataList = new ArrayList<TagMetadata>();
        for (ModelColumn col : model.getColumns()) {
            String columnStorageName = col.getColumnName().getStorageName();
            if (columnStorageName.equals("time_bucket")) continue;
            BanyandbDatabase.TagSpec tagSpec = this.parseTagSpec(col);
            builder.spec(columnStorageName, new ColumnSpec(ColumnType.TAG, col.getType()));
            String colName = col.getColumnName().getStorageName();
            if (col.getBanyanDBExtension().shouldIndex()) {
                if (!seriesIDColumns.contains(colName) || null != col.getBanyanDBExtension().getAnalyzer()) {
                    tagMetadataList.add(new TagMetadata(this.indexRule(group, tagSpec.getName(), col.getBanyanDBExtension().isEnableSort(), col.getBanyanDBExtension().getAnalyzer()), tagSpec));
                    continue;
                }
                tagMetadataList.add(new TagMetadata(null, tagSpec));
                continue;
            }
            tagMetadataList.add(new TagMetadata(null, tagSpec));
        }
        return tagMetadataList;
    }

    MeasureMetadata parseTagAndFieldMetadata(Model model, Schema.SchemaBuilder builder, List<String> seriesIDColumns, String group) {
        MeasureMetadata.MeasureMetadataBuilder result = MeasureMetadata.builder();
        for (ModelColumn col : model.getColumns()) {
            String columnStorageName = col.getColumnName().getStorageName();
            if (columnStorageName.equals("time_bucket")) continue;
            if (col.getBanyanDBExtension().isMeasureField()) {
                builder.spec(columnStorageName, new ColumnSpec(ColumnType.FIELD, col.getType()));
                result.field(this.parseFieldSpec(col));
                continue;
            }
            BanyandbDatabase.TagSpec tagSpec = this.parseTagSpec(col);
            builder.spec(columnStorageName, new ColumnSpec(ColumnType.TAG, col.getType()));
            String colName = col.getColumnName().getStorageName();
            if (col.getBanyanDBExtension().shouldIndex()) {
                if (!seriesIDColumns.contains(colName) || null != col.getBanyanDBExtension().getAnalyzer()) {
                    result.tag(new TagMetadata(this.indexRule(group, tagSpec.getName(), col.getBanyanDBExtension().isEnableSort(), col.getBanyanDBExtension().getAnalyzer()), tagSpec));
                    continue;
                }
                result.tag(new TagMetadata(null, tagSpec));
                continue;
            }
            result.tag(new TagMetadata(null, tagSpec));
        }
        return result.build();
    }

    @Nonnull
    private BanyandbDatabase.TagSpec parseTagSpec(ModelColumn modelColumn) {
        Class clazz = modelColumn.getType();
        String colName = modelColumn.getColumnName().getStorageName();
        BanyandbDatabase.TagSpec.Builder tagSpec = BanyandbDatabase.TagSpec.newBuilder().setName(colName);
        if (String.class.equals((Object)clazz) || StorageDataComplexObject.class.isAssignableFrom(clazz) || JsonObject.class.equals((Object)clazz)) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_STRING);
        } else if (Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Integer.class.equals((Object)clazz) || Long.class.equals((Object)clazz)) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_INT);
        } else if (byte[].class.equals((Object)clazz)) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_DATA_BINARY);
        } else if (clazz.isEnum()) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_INT);
        } else if (Double.TYPE.equals(clazz) || Double.class.equals((Object)clazz)) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_DATA_BINARY);
        } else if (IntList.class.isAssignableFrom(clazz)) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_INT_ARRAY);
        } else if (List.class.isAssignableFrom(clazz)) {
            ParameterizedType t = (ParameterizedType)modelColumn.getGenericType();
            if (String.class.equals((Object)t.getActualTypeArguments()[0])) {
                tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_STRING_ARRAY);
            }
        } else {
            throw new IllegalStateException("type " + modelColumn.getType().toString() + " is not supported");
        }
        if (modelColumn.isIndexOnly()) {
            tagSpec.setIndexedOnly(true);
        }
        return tagSpec.build();
    }

    public SchemaMetadata parseMetadata(Model model, BanyanDBStorageConfig config, DownSamplingConfigService configService) {
        if (!model.isTimeSeries()) {
            return new SchemaMetadata("property", model.getName(), Kind.PROPERTY, DownSampling.None, config.getProperty().getShardNum(), 0, 0);
        }
        if (model.isRecord()) {
            return new SchemaMetadata(model.isSuperDataset() ? model.getName() : "normal", model.getName(), Kind.STREAM, model.getDownsampling(), model.isSuperDataset() ? config.getRecordsSuper().getShardNum() : config.getRecordsNormal().getShardNum(), model.isSuperDataset() ? config.getRecordsSuper().getSegmentInterval() : config.getRecordsNormal().getSegmentInterval(), model.isSuperDataset() ? config.getRecordsSuper().getTtl() : config.getRecordsNormal().getTtl());
        }
        if (model.getBanyanDBModelExtension().isIndexMode()) {
            return new SchemaMetadata("index", model.getName(), Kind.MEASURE, model.getDownsampling(), config.getMetadata().getShardNum(), config.getMetadata().getSegmentInterval(), config.getMetadata().getTtl());
        }
        switch (model.getDownsampling()) {
            case Minute: {
                return new SchemaMetadata(DownSampling.Minute.getName(), model.getName(), Kind.MEASURE, model.getDownsampling(), config.getMetricsMin().getShardNum(), config.getMetricsMin().getSegmentInterval(), config.getMetricsMin().getTtl());
            }
            case Hour: {
                if (!configService.shouldToHour()) {
                    throw new UnsupportedOperationException("downsampling to hour is not supported");
                }
                return new SchemaMetadata(DownSampling.Hour.getName(), model.getName(), Kind.MEASURE, model.getDownsampling(), config.getMetricsHour().getShardNum(), config.getMetricsHour().getSegmentInterval(), config.getMetricsHour().getTtl());
            }
            case Day: {
                if (!configService.shouldToDay()) {
                    throw new UnsupportedOperationException("downsampling to day is not supported");
                }
                return new SchemaMetadata(DownSampling.Day.getName(), model.getName(), Kind.MEASURE, model.getDownsampling(), config.getMetricsDay().getShardNum(), config.getMetricsDay().getSegmentInterval(), config.getMetricsDay().getTtl());
            }
        }
        throw new UnsupportedOperationException("unsupported downSampling interval:" + model.getDownsampling());
    }

    static {
        log = LoggerFactory.getLogger(MetadataRegistry.class);
    }

    public static class SchemaMetadata {
        private final String group;
        private final String modelName;
        private final Kind kind;
        private final DownSampling downSampling;
        private final int shard;
        private final int segmentIntervalDays;
        private final int ttlDays;

        static String formatName(String modelName, DownSampling downSampling) {
            if (downSampling == null || downSampling == DownSampling.None) {
                return modelName;
            }
            return modelName + "_" + downSampling.getName();
        }

        private List<BanyandbDatabase.TagFamilySpec> extractTagFamilySpec(List<TagMetadata> tagMetadataList, boolean shouldAddID) {
            String indexFamily = this.indexFamily();
            String nonIndexFamily = this.nonIndexFamily();
            Map<String, List<TagMetadata>> tagMetadataMap = tagMetadataList.stream().collect(Collectors.groupingBy(tagMetadata -> tagMetadata.isIndex() ? indexFamily : nonIndexFamily));
            ArrayList<BanyandbDatabase.TagFamilySpec> tagFamilySpecs = new ArrayList<BanyandbDatabase.TagFamilySpec>(tagMetadataMap.size());
            for (Map.Entry<String, List<TagMetadata>> entry : tagMetadataMap.entrySet()) {
                BanyandbDatabase.TagFamilySpec.Builder b = BanyandbDatabase.TagFamilySpec.newBuilder();
                b.setName(entry.getKey());
                b.addAllTags((Iterable)entry.getValue().stream().map(TagMetadata::getTagSpec).collect(Collectors.toList()));
                if (shouldAddID && indexFamily.equals(entry.getKey())) {
                    b.addTags(BanyandbDatabase.TagSpec.newBuilder().setType(BanyandbDatabase.TagType.TAG_TYPE_STRING).setName("id"));
                }
                tagFamilySpecs.add(b.build());
            }
            return tagFamilySpecs;
        }

        public String name() {
            if (this.kind == Kind.MEASURE) {
                return SchemaMetadata.formatName(this.modelName, this.downSampling);
            }
            return this.modelName;
        }

        public String indexFamily() {
            switch (this.kind) {
                case MEASURE: {
                    return "default";
                }
                case STREAM: {
                    return "searchable";
                }
            }
            throw new IllegalStateException("should not reach here");
        }

        public String nonIndexFamily() {
            switch (this.kind) {
                case MEASURE: 
                case STREAM: {
                    return "storage-only";
                }
            }
            throw new IllegalStateException("should not reach here");
        }

        @Generated
        public SchemaMetadata(String group, String modelName, Kind kind, DownSampling downSampling, int shard, int segmentIntervalDays, int ttlDays) {
            this.group = group;
            this.modelName = modelName;
            this.kind = kind;
            this.downSampling = downSampling;
            this.shard = shard;
            this.segmentIntervalDays = segmentIntervalDays;
            this.ttlDays = ttlDays;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getModelName() {
            return this.modelName;
        }

        @Generated
        public Kind getKind() {
            return this.kind;
        }

        @Generated
        public DownSampling getDownSampling() {
            return this.downSampling;
        }

        @Generated
        public int getShard() {
            return this.shard;
        }

        @Generated
        public int getSegmentIntervalDays() {
            return this.segmentIntervalDays;
        }

        @Generated
        public int getTtlDays() {
            return this.ttlDays;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchemaMetadata)) {
                return false;
            }
            SchemaMetadata other = (SchemaMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getShard() != other.getShard()) {
                return false;
            }
            if (this.getSegmentIntervalDays() != other.getSegmentIntervalDays()) {
                return false;
            }
            if (this.getTtlDays() != other.getTtlDays()) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$modelName = this.getModelName();
            String other$modelName = other.getModelName();
            if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            DownSampling this$downSampling = this.getDownSampling();
            DownSampling other$downSampling = other.getDownSampling();
            return !(this$downSampling == null ? other$downSampling != null : !this$downSampling.equals(other$downSampling));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SchemaMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getShard();
            result = result * 59 + this.getSegmentIntervalDays();
            result = result * 59 + this.getTtlDays();
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $modelName = this.getModelName();
            result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            DownSampling $downSampling = this.getDownSampling();
            result = result * 59 + ($downSampling == null ? 43 : $downSampling.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetadataRegistry.SchemaMetadata(group=" + this.getGroup() + ", modelName=" + this.getModelName() + ", kind=" + this.getKind() + ", downSampling=" + this.getDownSampling() + ", shard=" + this.getShard() + ", segmentIntervalDays=" + this.getSegmentIntervalDays() + ", ttlDays=" + this.getTtlDays() + ")";
        }
    }

    public static class Schema {
        private final SchemaMetadata metadata;
        private final Map<String, ColumnSpec> specs;
        private final Set<String> tags;
        private final Set<String> fields;
        private final String timestampColumn4Stream;
        @Nullable
        private final BanyandbDatabase.TopNAggregation topNSpec;

        public ColumnSpec getSpec(String columnName) {
            return this.specs.get(columnName);
        }

        public static String formatTopNName(String measureName) {
            return measureName + "_topn";
        }

        @Generated
        Schema(SchemaMetadata metadata, Map<String, ColumnSpec> specs, Set<String> tags, Set<String> fields, String timestampColumn4Stream, @Nullable BanyandbDatabase.TopNAggregation topNSpec) {
            this.metadata = metadata;
            this.specs = specs;
            this.tags = tags;
            this.fields = fields;
            this.timestampColumn4Stream = timestampColumn4Stream;
            this.topNSpec = topNSpec;
        }

        @Generated
        public static SchemaBuilder builder() {
            return new SchemaBuilder();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Schema)) {
                return false;
            }
            Schema other = (Schema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SchemaMetadata this$metadata = this.getMetadata();
            SchemaMetadata other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            Map<String, ColumnSpec> this$specs = this.specs;
            Map<String, ColumnSpec> other$specs = other.specs;
            if (this$specs == null ? other$specs != null : !((Object)this$specs).equals(other$specs)) {
                return false;
            }
            Set<String> this$tags = this.getTags();
            Set<String> other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
                return false;
            }
            Set<String> this$fields = this.getFields();
            Set<String> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            String this$timestampColumn4Stream = this.getTimestampColumn4Stream();
            String other$timestampColumn4Stream = other.getTimestampColumn4Stream();
            if (this$timestampColumn4Stream == null ? other$timestampColumn4Stream != null : !this$timestampColumn4Stream.equals(other$timestampColumn4Stream)) {
                return false;
            }
            BanyandbDatabase.TopNAggregation this$topNSpec = this.getTopNSpec();
            BanyandbDatabase.TopNAggregation other$topNSpec = other.getTopNSpec();
            return !(this$topNSpec == null ? other$topNSpec != null : !this$topNSpec.equals(other$topNSpec));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Schema;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchemaMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            Map<String, ColumnSpec> $specs = this.specs;
            result = result * 59 + ($specs == null ? 43 : ((Object)$specs).hashCode());
            Set<String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            Set<String> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            String $timestampColumn4Stream = this.getTimestampColumn4Stream();
            result = result * 59 + ($timestampColumn4Stream == null ? 43 : $timestampColumn4Stream.hashCode());
            BanyandbDatabase.TopNAggregation $topNSpec = this.getTopNSpec();
            result = result * 59 + ($topNSpec == null ? 43 : $topNSpec.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetadataRegistry.Schema(metadata=" + this.getMetadata() + ", specs=" + this.specs + ", tags=" + this.getTags() + ", fields=" + this.getFields() + ", timestampColumn4Stream=" + this.getTimestampColumn4Stream() + ", topNSpec=" + this.getTopNSpec() + ")";
        }

        @Generated
        public SchemaMetadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public Set<String> getTags() {
            return this.tags;
        }

        @Generated
        public Set<String> getFields() {
            return this.fields;
        }

        @Generated
        public String getTimestampColumn4Stream() {
            return this.timestampColumn4Stream;
        }

        @Nullable
        @Generated
        public BanyandbDatabase.TopNAggregation getTopNSpec() {
            return this.topNSpec;
        }

        @Generated
        public static class SchemaBuilder {
            @Generated
            private SchemaMetadata metadata;
            @Generated
            private ArrayList<String> specs$key;
            @Generated
            private ArrayList<ColumnSpec> specs$value;
            @Generated
            private ArrayList<String> tags;
            @Generated
            private ArrayList<String> fields;
            @Generated
            private String timestampColumn4Stream;
            @Generated
            private BanyandbDatabase.TopNAggregation topNSpec;

            @Generated
            SchemaBuilder() {
            }

            @Generated
            public SchemaBuilder metadata(SchemaMetadata metadata) {
                this.metadata = metadata;
                return this;
            }

            @Generated
            public SchemaBuilder spec(String specKey, ColumnSpec specValue) {
                if (this.specs$key == null) {
                    this.specs$key = new ArrayList();
                    this.specs$value = new ArrayList();
                }
                this.specs$key.add(specKey);
                this.specs$value.add(specValue);
                return this;
            }

            @Generated
            public SchemaBuilder specs(Map<? extends String, ? extends ColumnSpec> specs) {
                if (specs == null) {
                    throw new NullPointerException("specs cannot be null");
                }
                if (this.specs$key == null) {
                    this.specs$key = new ArrayList();
                    this.specs$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends ColumnSpec> $lombokEntry : specs.entrySet()) {
                    this.specs$key.add($lombokEntry.getKey());
                    this.specs$value.add($lombokEntry.getValue());
                }
                return this;
            }

            @Generated
            public SchemaBuilder clearSpecs() {
                if (this.specs$key != null) {
                    this.specs$key.clear();
                    this.specs$value.clear();
                }
                return this;
            }

            @Generated
            public SchemaBuilder tag(String tag) {
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.add(tag);
                return this;
            }

            @Generated
            public SchemaBuilder tags(Collection<? extends String> tags) {
                if (tags == null) {
                    throw new NullPointerException("tags cannot be null");
                }
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.addAll(tags);
                return this;
            }

            @Generated
            public SchemaBuilder clearTags() {
                if (this.tags != null) {
                    this.tags.clear();
                }
                return this;
            }

            @Generated
            public SchemaBuilder field(String field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            @Generated
            public SchemaBuilder fields(Collection<? extends String> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            @Generated
            public SchemaBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            @Generated
            public SchemaBuilder timestampColumn4Stream(String timestampColumn4Stream) {
                this.timestampColumn4Stream = timestampColumn4Stream;
                return this;
            }

            @Generated
            public SchemaBuilder topNSpec(@Nullable BanyandbDatabase.TopNAggregation topNSpec) {
                this.topNSpec = topNSpec;
                return this;
            }

            @Generated
            public Schema build() {
                Set<Object> fields;
                Set<Object> tags;
                Map<Object, Object> specs;
                switch (this.specs$key == null ? 0 : this.specs$key.size()) {
                    case 0: {
                        specs = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        specs = Collections.singletonMap(this.specs$key.get(0), this.specs$value.get(0));
                        break;
                    }
                    default: {
                        specs = new LinkedHashMap(this.specs$key.size() < 0x40000000 ? 1 + this.specs$key.size() + (this.specs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.specs$key.size(); ++$i) {
                            specs.put(this.specs$key.get($i), this.specs$value.get($i));
                        }
                        specs = Collections.unmodifiableMap(specs);
                    }
                }
                switch (this.tags == null ? 0 : this.tags.size()) {
                    case 0: {
                        tags = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        tags = Collections.singleton(this.tags.get(0));
                        break;
                    }
                    default: {
                        tags = new LinkedHashSet(this.tags.size() < 0x40000000 ? 1 + this.tags.size() + (this.tags.size() - 3) / 3 : Integer.MAX_VALUE);
                        tags.addAll(this.tags);
                        tags = Collections.unmodifiableSet(tags);
                    }
                }
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        fields = Collections.singleton(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = new LinkedHashSet(this.fields.size() < 0x40000000 ? 1 + this.fields.size() + (this.fields.size() - 3) / 3 : Integer.MAX_VALUE);
                        fields.addAll(this.fields);
                        fields = Collections.unmodifiableSet(fields);
                    }
                }
                return new Schema(this.metadata, specs, tags, fields, this.timestampColumn4Stream, this.topNSpec);
            }

            @Generated
            public String toString() {
                return "MetadataRegistry.Schema.SchemaBuilder(metadata=" + this.metadata + ", specs$key=" + this.specs$key + ", specs$value=" + this.specs$value + ", tags=" + this.tags + ", fields=" + this.fields + ", timestampColumn4Stream=" + this.timestampColumn4Stream + ", topNSpec=" + this.topNSpec + ")";
            }
        }
    }

    private static class MeasureMetadata {
        private final List<TagMetadata> tags;
        private final List<BanyandbDatabase.FieldSpec> fields;

        @Generated
        MeasureMetadata(List<TagMetadata> tags, List<BanyandbDatabase.FieldSpec> fields) {
            this.tags = tags;
            this.fields = fields;
        }

        @Generated
        public static MeasureMetadataBuilder builder() {
            return new MeasureMetadataBuilder();
        }

        @Generated
        public static class MeasureMetadataBuilder {
            @Generated
            private ArrayList<TagMetadata> tags;
            @Generated
            private ArrayList<BanyandbDatabase.FieldSpec> fields;

            @Generated
            MeasureMetadataBuilder() {
            }

            @Generated
            public MeasureMetadataBuilder tag(TagMetadata tag) {
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.add(tag);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder tags(Collection<? extends TagMetadata> tags) {
                if (tags == null) {
                    throw new NullPointerException("tags cannot be null");
                }
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.addAll(tags);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder clearTags() {
                if (this.tags != null) {
                    this.tags.clear();
                }
                return this;
            }

            @Generated
            public MeasureMetadataBuilder field(BanyandbDatabase.FieldSpec field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder fields(Collection<? extends BanyandbDatabase.FieldSpec> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            @Generated
            public MeasureMetadata build() {
                List<BanyandbDatabase.FieldSpec> fields;
                List<TagMetadata> tags;
                switch (this.tags == null ? 0 : this.tags.size()) {
                    case 0: {
                        tags = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        tags = Collections.singletonList(this.tags.get(0));
                        break;
                    }
                    default: {
                        tags = Collections.unmodifiableList(new ArrayList<TagMetadata>(this.tags));
                    }
                }
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        fields = Collections.singletonList(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = Collections.unmodifiableList(new ArrayList<BanyandbDatabase.FieldSpec>(this.fields));
                    }
                }
                return new MeasureMetadata(tags, fields);
            }

            @Generated
            public String toString() {
                return "MetadataRegistry.MeasureMetadata.MeasureMetadataBuilder(tags=" + this.tags + ", fields=" + this.fields + ")";
            }
        }
    }

    private static class TagMetadata {
        private final BanyandbDatabase.IndexRule indexRule;
        private final BanyandbDatabase.TagSpec tagSpec;

        boolean isIndex() {
            return this.indexRule != null;
        }

        @Generated
        public TagMetadata(BanyandbDatabase.IndexRule indexRule, BanyandbDatabase.TagSpec tagSpec) {
            this.indexRule = indexRule;
            this.tagSpec = tagSpec;
        }

        @Generated
        public BanyandbDatabase.IndexRule getIndexRule() {
            return this.indexRule;
        }

        @Generated
        public BanyandbDatabase.TagSpec getTagSpec() {
            return this.tagSpec;
        }
    }

    public static enum Kind {
        MEASURE,
        STREAM,
        PROPERTY;

    }

    public static class ColumnSpec {
        private final ColumnType columnType;
        private final Class<?> columnClass;

        @Generated
        public ColumnSpec(ColumnType columnType, Class<?> columnClass) {
            this.columnType = columnType;
            this.columnClass = columnClass;
        }

        @Generated
        public ColumnType getColumnType() {
            return this.columnType;
        }

        @Generated
        public Class<?> getColumnClass() {
            return this.columnClass;
        }

        @Generated
        public String toString() {
            return "MetadataRegistry.ColumnSpec(columnType=" + this.getColumnType() + ", columnClass=" + this.getColumnClass() + ")";
        }
    }

    public static enum ColumnType {
        TAG,
        FIELD;

    }
}

