/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.type.Bucket;

public class HeatMap {
    private List<HeatMapColumn> values = new ArrayList<HeatMapColumn>(10);
    private List<Bucket> buckets = new ArrayList<Bucket>();

    public void addBucket(Bucket bucket) {
        this.buckets.add(bucket);
    }

    public void buildColumn(String id, String rawdata, int defaultValue) {
        DataTable dataset = new DataTable(rawdata);
        List<String> sortedKeys = dataset.sortedKeys(new KeyComparator(true));
        if (this.buckets.isEmpty()) {
            for (int i = 0; i < sortedKeys.size(); ++i) {
                Bucket bucket = new Bucket();
                String minValue = sortedKeys.get(i);
                if ("infinite-".equals(minValue)) {
                    bucket.infiniteMin();
                } else {
                    bucket.setMin(Integer.parseInt(minValue));
                }
                if (i == sortedKeys.size() - 1) {
                    bucket.infiniteMax();
                } else {
                    String max = sortedKeys.get(i + 1);
                    if ("infinite+".equals(max)) {
                        bucket.infiniteMax();
                        break;
                    }
                    bucket.setMax(Integer.parseInt(max));
                }
                this.addBucket(bucket);
            }
        }
        HeatMapColumn column = new HeatMapColumn();
        column.setId(id);
        sortedKeys.forEach(key -> {
            if (dataset.hasKey((String)key)) {
                column.addValue(dataset.get((String)key));
            } else {
                column.addValue(Long.valueOf(defaultValue));
            }
        });
        this.values.add(column);
    }

    public void fixMissingColumns(List<String> ids, int defaultValue) {
        for (int i = 0; i < ids.size(); ++i) {
            String expectedId = ids.get(i);
            boolean found = false;
            for (HeatMapColumn value : this.values) {
                if (!expectedId.equals(value.id)) continue;
                found = true;
            }
            if (found) continue;
            HeatMapColumn emptyColumn = this.buildMissingColumn(expectedId, defaultValue);
            this.values.add(i, emptyColumn);
        }
    }

    private HeatMapColumn buildMissingColumn(String id, int defaultValue) {
        HeatMapColumn column = new HeatMapColumn();
        column.setId(id);
        this.buckets.forEach(bucket -> column.addValue(Long.valueOf(defaultValue)));
        return column;
    }

    @Generated
    public List<HeatMapColumn> getValues() {
        return this.values;
    }

    @Generated
    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    public static class KeyComparator
    implements Comparator<String> {
        private final boolean asc;

        @Override
        public int compare(String k1, String k2) {
            String[] kk2;
            String[] kk1 = this.parseKey(k1);
            int result = kk1[0].compareTo((kk2 = this.parseKey(k2))[0]);
            if (result != 0) {
                return result;
            }
            String key1 = kk1[1];
            String key2 = kk2[1];
            result = key1.equals(key2) ? 0 : ("infinite-".equals(key1) || "infinite+".equals(key2) ? -1 : ("infinite-".equals(key2) || "infinite+".equals(key1) ? 1 : new BigInteger(key1).subtract(new BigInteger(key2)).signum()));
            return this.asc ? result : -result;
        }

        private String[] parseKey(String key) {
            if (key.contains(":")) {
                return new String[]{StringUtils.substringBeforeLast((String)key, (String)":"), StringUtils.substringAfterLast((String)key, (String)":")};
            }
            return new String[]{"default", key};
        }

        @Generated
        public KeyComparator(boolean asc) {
            this.asc = asc;
        }
    }

    public static class HeatMapColumn {
        private String id;
        private List<Long> values = new ArrayList<Long>();

        public void addValue(Long value) {
            this.values.add(value);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public List<Long> getValues() {
            return this.values;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }
    }
}

