/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.MetricName;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.metrics.Measurable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.metrics.Metrics;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.metrics.Sensor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.metrics.stats.Max;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.metrics.stats.Meter;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.metrics.stats.WindowedCount;

public class HeartbeatMetricsManager {
    final MetricName heartbeatResponseTimeMax;
    final MetricName heartbeatRate;
    final MetricName heartbeatTotal;
    final MetricName lastHeartbeatSecondsAgo;
    private final Sensor heartbeatSensor;
    private long lastHeartbeatMs = -1L;

    public HeartbeatMetricsManager(Metrics metrics) {
        this(metrics, "consumer");
    }

    public HeartbeatMetricsManager(Metrics metrics, String metricGroupPrefix) {
        String metricGroupName = metricGroupPrefix + "-coordinator-metrics";
        this.heartbeatSensor = metrics.sensor("heartbeat-latency");
        this.heartbeatResponseTimeMax = metrics.metricName("heartbeat-response-time-max", metricGroupName, "The max time taken to receive a response to a heartbeat request");
        this.heartbeatSensor.add(this.heartbeatResponseTimeMax, new Max());
        this.heartbeatRate = metrics.metricName("heartbeat-rate", metricGroupName, "The number of heartbeats per second");
        this.heartbeatTotal = metrics.metricName("heartbeat-total", metricGroupName, "The total number of heartbeats");
        this.heartbeatSensor.add(new Meter(new WindowedCount(), this.heartbeatRate, this.heartbeatTotal));
        Measurable lastHeartbeat = (config, now) -> {
            long lastHeartbeatSend = this.lastHeartbeatMs;
            if (lastHeartbeatSend < 0L) {
                return -1.0;
            }
            return TimeUnit.SECONDS.convert(now - lastHeartbeatSend, TimeUnit.MILLISECONDS);
        };
        this.lastHeartbeatSecondsAgo = metrics.metricName("last-heartbeat-seconds-ago", metricGroupName, "The number of seconds since the last coordinator heartbeat was sent");
        metrics.addMetric(this.lastHeartbeatSecondsAgo, lastHeartbeat);
    }

    public void recordHeartbeatSentMs(long timeMs) {
        this.lastHeartbeatMs = timeMs;
    }

    public void recordRequestLatency(long requestLatencyMs) {
        this.heartbeatSensor.record(requestLatencyMs);
    }
}

