/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentparser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.jcr.contentparser.ContentHandler;
import org.apache.sling.jcr.contentparser.ContentParser;
import org.apache.sling.jcr.contentparser.JsonParserFeature;
import org.apache.sling.jcr.contentparser.ParseException;
import org.apache.sling.jcr.contentparser.ParserOptions;
import org.apache.sling.jcr.contentparser.impl.JsonTicksConverter;
import org.apache.sling.jcr.contentparser.impl.ParserHelper;

public final class JsonContentParser
implements ContentParser {
    private final ParserHelper helper;
    private final JsonReaderFactory jsonReaderFactory;
    private final boolean jsonQuoteTickets;

    public JsonContentParser(ParserOptions options) {
        this.helper = new ParserHelper(options);
        HashMap<String, Boolean> jsonReaderFactoryConfig = new HashMap<String, Boolean>();
        if (options.getJsonParserFeatures().contains((Object)JsonParserFeature.COMMENTS)) {
            jsonReaderFactoryConfig.put("org.apache.johnzon.supports-comments", true);
        }
        this.jsonQuoteTickets = options.getJsonParserFeatures().contains((Object)JsonParserFeature.QUOTE_TICK);
        this.jsonReaderFactory = Json.createReaderFactory(jsonReaderFactoryConfig);
    }

    @Override
    public void parse(ContentHandler handler, InputStream is) throws IOException, ParseException {
        this.parse(handler, this.toJsonObject(is), "/");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject toJsonObject(InputStream is) {
        if (this.jsonQuoteTickets) {
            return this.toJsonObjectWithJsonTicks(is);
        }
        try (JsonReader reader = this.jsonReaderFactory.createReader(is);){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
        catch (JsonParsingException ex) {
            throw new ParseException("Error parsing JSON content: " + ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject toJsonObjectWithJsonTicks(InputStream is) {
        String jsonString;
        try {
            jsonString = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (IOException ex) {
            throw new ParseException("Error getting JSON string.", ex);
        }
        jsonString = JsonTicksConverter.tickToDoubleQuote(jsonString);
        try (JsonReader reader = this.jsonReaderFactory.createReader((Reader)new StringReader(jsonString));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
        catch (JsonParsingException ex) {
            throw new ParseException("Error parsing JSON content: " + ex.getMessage(), ex);
        }
    }

    private void parse(ContentHandler handler, JsonObject object, String path) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        LinkedHashMap<String, JsonObject> children = new LinkedHashMap<String, JsonObject>();
        for (Map.Entry entry : object.entrySet()) {
            String childName = (String)entry.getKey();
            Object value = null;
            boolean ignore = false;
            try {
                value = this.convertValue((JsonValue)entry.getValue());
            }
            catch (ParseException ex) {
                if (this.helper.ignoreResource(childName) || this.helper.ignoreProperty(this.helper.cleanupPropertyName(childName))) {
                    ignore = true;
                }
                throw ex;
            }
            boolean isResource = value instanceof JsonObject;
            if (!ignore) {
                if (isResource) {
                    ignore = this.helper.ignoreResource(childName);
                } else {
                    childName = this.helper.cleanupPropertyName(childName);
                    ignore = this.helper.ignoreProperty(childName);
                }
            }
            if (ignore) continue;
            if (isResource) {
                children.put(childName, (JsonObject)value);
                continue;
            }
            properties.put(childName, value);
        }
        this.helper.ensureDefaultPrimaryType(properties);
        handler.resource(path, properties);
        for (Map.Entry entry : children.entrySet()) {
            String childPath = this.helper.concatenatePath(path, (String)entry.getKey());
            this.parse(handler, (JsonObject)entry.getValue(), childPath);
        }
    }

    private Object convertValue(JsonValue value) {
        switch (value.getValueType()) {
            case STRING: {
                String stringValue = ((JsonString)value).getString();
                Calendar calendarValue = this.helper.tryParseCalendar(stringValue);
                if (calendarValue != null) {
                    return calendarValue;
                }
                return stringValue;
            }
            case NUMBER: {
                JsonNumber numberValue = (JsonNumber)value;
                if (numberValue.isIntegral()) {
                    return numberValue.longValue();
                }
                return numberValue.bigDecimalValue();
            }
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case NULL: {
                return null;
            }
            case ARRAY: {
                JsonArray arrayValue = (JsonArray)value;
                Object[] values = new Object[arrayValue.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.convertValue((JsonValue)arrayValue.get(i));
                }
                return this.helper.convertSingleTypeArray(values);
            }
            case OBJECT: {
                return (JsonObject)value;
            }
        }
        throw new ParseException("Unexpected JSON value type: " + value.getValueType());
    }
}

