/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi;

import java.nio.file.Path;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidationMessage {
    @NotNull
    private final ValidationMessageSeverity severity;
    @NotNull
    private final String message;
    private final int line;
    private final int column;
    private final Throwable throwable;
    private final String nodePath;
    private final Path filePath;
    private final Path basePath;

    public ValidationMessage(@NotNull ValidationMessageSeverity severity, @NotNull String message) {
        this(severity, message, 0, 0, null);
    }

    public ValidationMessage(@NotNull ValidationMessageSeverity severity, @NotNull String message, Throwable throwable) {
        this(severity, message, 0, 0, throwable);
    }

    public ValidationMessage(@NotNull ValidationMessageSeverity severity, @NotNull String message, int line, int column, Throwable throwable) {
        this(severity, message, null, null, line, column, throwable);
    }

    public ValidationMessage(@NotNull ValidationMessageSeverity severity, @NotNull String message, @NotNull String nodePath, @NotNull Path filePath, @NotNull Path basePath, Throwable throwable) {
        this(severity, message, nodePath, filePath, basePath, 0, 0, throwable);
    }

    public ValidationMessage(@NotNull ValidationMessageSeverity severity, @NotNull String message, @NotNull NodeContext nodeContext) {
        this(severity, message, nodeContext.getNodePath(), nodeContext.getFilePath(), nodeContext.getBasePath(), 0, 0, null);
    }

    public ValidationMessage(@NotNull ValidationMessageSeverity severity, @NotNull String message, @NotNull NodeContext nodeContext, Throwable throwable) {
        this(severity, message, nodeContext.getNodePath(), nodeContext.getFilePath(), nodeContext.getBasePath(), 0, 0, throwable);
    }

    public ValidationMessage(@NotNull ValidationMessageSeverity severity, @NotNull String message, Path filePath, Path basePath, int line, int column, Throwable throwable) {
        this(severity, message, null, filePath, basePath, line, column, throwable);
    }

    public ValidationMessage(@NotNull ValidationMessageSeverity severity, @NotNull String message, String nodePath, Path filePath, Path basePath, int line, int column, Throwable throwable) {
        this.severity = severity;
        this.message = message;
        this.line = line;
        this.column = column;
        this.throwable = throwable;
        this.filePath = filePath;
        this.basePath = basePath;
        this.nodePath = nodePath;
    }

    @NotNull
    public ValidationMessageSeverity getSeverity() {
        return this.severity;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Nullable
    public Path getFilePath() {
        return this.filePath;
    }

    @Nullable
    public Path getBasePath() {
        return this.basePath;
    }

    @Nullable
    public String getNodePath() {
        return this.nodePath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.basePath == null ? 0 : this.basePath.hashCode());
        result = 31 * result + this.column;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + this.line;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.nodePath == null ? 0 : this.nodePath.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationMessage other = (ValidationMessage)obj;
        if (this.basePath == null ? other.basePath != null : !this.basePath.equals(other.basePath)) {
            return false;
        }
        if (this.column != other.column) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        if (!this.message.equals(other.message)) {
            return false;
        }
        if (this.nodePath == null ? other.nodePath != null : !this.nodePath.equals(other.nodePath)) {
            return false;
        }
        return this.severity == other.severity;
    }

    public String toString() {
        return "ValidationMessage [" + (this.severity != null ? "severity=" + (Object)((Object)this.severity) + ", " : "") + (this.message != null ? "message=" + this.message + ", " : "") + "line=" + this.line + ", column=" + this.column + ", " + (this.throwable != null ? "throwable=" + this.throwable + ", " : "") + (this.nodePath != null ? "nodePath=" + this.nodePath + ", " : "") + (this.filePath != null ? "filePath=" + this.filePath + ", " : "") + (this.basePath != null ? "basePath=" + this.basePath : "") + "]";
    }
}

