/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.json.io.impl;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonValue;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.felix.cm.json.io.impl.JsonSupport;
import org.osgi.util.converter.ConversionException;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.osgi.util.converter.TypeReference;

public class TypeConverter {
    public static final String TYPE_BINARY = "binary";
    public static final String TYPE_BINARIES = "binary[]";
    private static final String TYPE_COLLECTION = "Collection";
    public static final String NO_TYPE_INFO = "";
    public static final Object CONVERSION_FAILED = new Object();
    private static final Map<String, Class<?>> TYPE_MAP = new LinkedHashMap();
    private static final Map<String, TypeReference<?>> TYPE_COLLECTION_MAP = new LinkedHashMap();

    public static Object convertObjectToType(JsonValue jsonValue, String typeInfo) throws IllegalArgumentException {
        Object value = JsonSupport.convertToObject(jsonValue);
        if (typeInfo == null) {
            return value;
        }
        Class<?> typeClass = TYPE_MAP.get(typeInfo);
        if (typeClass != null) {
            Object result = null;
            try {
                result = ((Converting)Converters.standardConverter().convert(value).defaultValue(null)).to(typeClass);
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
            if (result == null && value != null) {
                result = CONVERSION_FAILED;
            }
            return result;
        }
        TypeReference<?> typeReference = TYPE_COLLECTION_MAP.get(typeInfo);
        if (typeReference != null) {
            if (value == null) {
                return Collections.EMPTY_LIST;
            }
            Object result = null;
            try {
                result = ((Converting)Converters.standardConverter().convert(value).defaultValue(null)).to(typeReference);
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
            if (result == null) {
                result = CONVERSION_FAILED;
            }
            return result;
        }
        if (TYPE_COLLECTION.equals(typeInfo)) {
            if (value == null) {
                return Collections.EMPTY_LIST;
            }
            if (value instanceof String || value instanceof Boolean || value instanceof Long || value instanceof Double) {
                return Collections.singletonList(value);
            }
            ArrayList<Object> c = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                c.add(Array.get(value, i));
            }
            return Collections.unmodifiableCollection(c);
        }
        return CONVERSION_FAILED;
    }

    private static String findType(Class<?> clazz) {
        for (Map.Entry<String, Class<?>> entry : TYPE_MAP.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Map.Entry<String, JsonValue> convertObjectToTypedJsonValue(Object value) {
        String typeInfo;
        if (value == null || value instanceof Long || value instanceof Double || value instanceof String || value instanceof Boolean) {
            return new Entry(NO_TYPE_INFO, JsonSupport.convertToJson(value));
        }
        if (value.getClass().isArray()) {
            typeInfo = TypeConverter.findType(value.getClass());
            if (typeInfo != null) {
                if ("String[]".equals(typeInfo) || "Boolean[]".equals(typeInfo) || "Long[]".equals(typeInfo) || "Double[]".equals(typeInfo)) {
                    typeInfo = NO_TYPE_INFO;
                }
                JsonArrayBuilder jab = Json.createArrayBuilder();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    jab.add(TypeConverter.convertObjectToTypedJsonValue(Array.get(value, i)).getValue());
                }
                return new Entry(typeInfo, (JsonValue)jab.build());
            }
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            String colType;
            Collection collection = (Collection)value;
            String typeInfo2 = TYPE_COLLECTION;
            Iterator i = collection.iterator();
            if (i.hasNext() && (colType = TypeConverter.findType(i.next().getClass())) != null) {
                typeInfo2 = typeInfo2.concat("<").concat(colType).concat(">");
            }
            JsonArrayBuilder jab = Json.createArrayBuilder();
            for (Object obj : collection) {
                jab.add(JsonSupport.convertToJson(obj));
            }
            return new Entry(typeInfo2, (JsonValue)jab.build());
        }
        if (value instanceof Integer) {
            return new Entry("Integer", (JsonValue)Json.createValue((int)((Integer)value)));
        }
        if (value instanceof Float) {
            return new Entry("Float", (JsonValue)Json.createValue((double)((Float)value).floatValue()));
        }
        if (value instanceof Short) {
            return new Entry("Short", (JsonValue)Json.createValue((int)((Short)value).shortValue()));
        }
        if (value instanceof Byte) {
            return new Entry("Byte", (JsonValue)Json.createValue((int)((Byte)value).byteValue()));
        }
        if (value instanceof Character) {
            return new Entry("Character", (JsonValue)Json.createValue((String)value.toString()));
        }
        typeInfo = TypeConverter.findType(value.getClass());
        if (typeInfo != null) {
            return new Entry(typeInfo, JsonSupport.convertToJson(value.toString()));
        }
        return new Entry(NO_TYPE_INFO, JsonSupport.convertToJson(value));
    }

    static {
        TYPE_MAP.put("String", String.class);
        TYPE_MAP.put("Integer", Integer.class);
        TYPE_MAP.put("int", Integer.class);
        TYPE_MAP.put("Long", Long.class);
        TYPE_MAP.put("long", Long.class);
        TYPE_MAP.put("Float", Float.class);
        TYPE_MAP.put("float", Float.class);
        TYPE_MAP.put("Double", Double.class);
        TYPE_MAP.put("double", Double.class);
        TYPE_MAP.put("Byte", Byte.class);
        TYPE_MAP.put("byte", Byte.class);
        TYPE_MAP.put("Short", Short.class);
        TYPE_MAP.put("short", Short.class);
        TYPE_MAP.put("Character", Character.class);
        TYPE_MAP.put("char", Character.class);
        TYPE_MAP.put("Boolean", Boolean.class);
        TYPE_MAP.put("boolean", Boolean.class);
        TYPE_MAP.put("String[]", String[].class);
        TYPE_MAP.put("int[]", int[].class);
        TYPE_MAP.put("Integer[]", Integer[].class);
        TYPE_MAP.put("long[]", long[].class);
        TYPE_MAP.put("Long[]", Long[].class);
        TYPE_MAP.put("float[]", float[].class);
        TYPE_MAP.put("Float[]", Float[].class);
        TYPE_MAP.put("double[]", double[].class);
        TYPE_MAP.put("Double[]", Double[].class);
        TYPE_MAP.put("byte[]", byte[].class);
        TYPE_MAP.put("Byte[]", Byte[].class);
        TYPE_MAP.put("short[]", short[].class);
        TYPE_MAP.put("Short[]", Short[].class);
        TYPE_MAP.put("boolean[]", boolean[].class);
        TYPE_MAP.put("Boolean[]", Boolean[].class);
        TYPE_MAP.put("char[]", char[].class);
        TYPE_MAP.put("Character[]", Character[].class);
        TYPE_MAP.put(TYPE_BINARY, String.class);
        TYPE_MAP.put(TYPE_BINARIES, String[].class);
        TYPE_COLLECTION_MAP.put("Collection<String>", new TypeReference<ArrayList<String>>(){});
        TYPE_COLLECTION_MAP.put("Collection<Integer>", new TypeReference<ArrayList<Integer>>(){});
        TYPE_COLLECTION_MAP.put("Collection<Long>", new TypeReference<ArrayList<Long>>(){});
        TYPE_COLLECTION_MAP.put("Collection<Float>", new TypeReference<ArrayList<Float>>(){});
        TYPE_COLLECTION_MAP.put("Collection<Double>", new TypeReference<ArrayList<Double>>(){});
        TYPE_COLLECTION_MAP.put("Collection<Byte>", new TypeReference<ArrayList<Byte>>(){});
        TYPE_COLLECTION_MAP.put("Collection<Short>", new TypeReference<ArrayList<Short>>(){});
        TYPE_COLLECTION_MAP.put("Collection<Character>", new TypeReference<ArrayList<Character>>(){});
        TYPE_COLLECTION_MAP.put("Collection<Boolean>", new TypeReference<ArrayList<Boolean>>(){});
    }

    private static final class Entry
    implements Map.Entry<String, JsonValue> {
        private final JsonValue value;
        private final String type;

        public Entry(String type, JsonValue value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.type;
        }

        @Override
        public JsonValue getValue() {
            return this.value;
        }

        @Override
        public JsonValue setValue(JsonValue value) {
            return null;
        }
    }
}

