/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.ml.stat.ChiSquareTest;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaChiSquareTestExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaChiSquareTestExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{0.0, Vectors.dense((double)0.5, (double[])new double[]{10.0})}), RowFactory.create((Object[])new Object[]{0.0, Vectors.dense((double)1.5, (double[])new double[]{20.0})}), RowFactory.create((Object[])new Object[]{1.0, Vectors.dense((double)1.5, (double[])new double[]{30.0})}), RowFactory.create((Object[])new Object[]{0.0, Vectors.dense((double)3.5, (double[])new double[]{30.0})}), RowFactory.create((Object[])new Object[]{0.0, Vectors.dense((double)3.5, (double[])new double[]{40.0})}), RowFactory.create((Object[])new Object[]{1.0, Vectors.dense((double)3.5, (double[])new double[]{40.0})}));
        StructType schema = new StructType(new StructField[]{new StructField("label", DataTypes.DoubleType, false, Metadata.empty()), new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        Row r = (Row)ChiSquareTest.test((Dataset)df, (String)"features", (String)"label").head();
        System.out.println("pValues: " + r.get(0).toString());
        System.out.println("degreesOfFreedom: " + r.getList(1).toString());
        System.out.println("statistics: " + r.get(2).toString());
        spark.stop();
    }
}

