/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FilterIntervalDayTimeScalarGreaterEqualIntervalDayTimeColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private HiveIntervalDayTime value;

    public FilterIntervalDayTimeScalarGreaterEqualIntervalDayTimeColumn(HiveIntervalDayTime value, int colNum) {
        this.colNum = colNum;
        this.value = value;
    }

    public FilterIntervalDayTimeScalarGreaterEqualIntervalDayTimeColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        IntervalDayTimeColumnVector inputColVector2 = (IntervalDayTimeColumnVector)batch.cols[this.colNum];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector2.isNull;
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (inputColVector2.noNulls) {
            if (inputColVector2.isRepeating) {
                if (inputColVector2.compareTo(this.value, 0) < 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (inputColVector2.compareTo(this.value, i) < 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (inputColVector2.compareTo(this.value, i) < 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (!nullPos[0]) {
                if (inputColVector2.compareTo(this.value, 0) < 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || inputColVector2.compareTo(this.value, i) < 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || inputColVector2.compareTo(this.value, i) < 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + this.value.toString() + ", col " + this.colNum;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

