/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.XXH64;
import org.apache.spark.sql.catalyst.expressions.XxHash64$;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, ...) - Returns a 64-bit hash value of the arguments. Hash seed is 42.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', array(123), 2);\n       5602566077635097486\n  ", since="3.0.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001\u0002\u0010 \u00012B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0011\"Aq\n\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005R\u0001\tE\t\u0015!\u00032\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015\u0011\u0006\u0001\"\u0001X\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015a\u0007\u0001\"\u0015d\u0011\u0015i\u0007\u0001\"\u0015o\u0011\u0015\u0011\b\u0001\"\u0015t\u0011\u0015Y\b\u0001\"\u0015}\u0011%\t)\u0001AA\u0001\n\u0003\t9\u0001C\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003W\u0001\u0011\u0011!C!\u0003[A\u0011\"!\u0010\u0001\u0003\u0003%\t!a\u0010\t\u0013\u0005\u001d\u0003!!A\u0005\u0002\u0005%\u0003\"CA(\u0001\u0005\u0005I\u0011IA)\u0011%\ty\u0006AA\u0001\n\u0003\t\t\u0007C\u0005\u0002f\u0001\t\t\u0011\"\u0011\u0002h!I\u00111\u000e\u0001\u0002\u0002\u0013\u0005\u0013QN\u0004\n\u0003#{\u0012\u0011!E\u0001\u0003'3\u0001BH\u0010\u0002\u0002#\u0005\u0011Q\u0013\u0005\u0007%b!\t!!,\t\u0013\u0005=\u0006$!A\u0005F\u0005E\u0006\"CAZ1\u0005\u0005I\u0011QA[\u0011%\tY\fGA\u0001\n\u0003\u000bi\fC\u0005\u0002Pb\t\t\u0011\"\u0003\u0002R\nA\u0001\f\u001f%bg\"4DG\u0003\u0002!C\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u00113%\u0001\u0005dCR\fG._:u\u0015\t!S%A\u0002tc2T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001'\u0011\u0001Qf\u000e\u001e\u0011\u00079z\u0013'D\u0001 \u0013\t\u0001tD\u0001\bICNDW\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\t1{gn\u001a\t\u0003eaJ!!O\u001a\u0003\u000fA\u0013x\u000eZ;diB\u00111h\u0011\b\u0003y\u0005s!!\u0010!\u000e\u0003yR!aP\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014B\u0001\"4\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001R#\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\t\u001b\u0014\u0001C2iS2$'/\u001a8\u0016\u0003!\u00032aO%L\u0013\tQUIA\u0002TKF\u0004\"A\f'\n\u00055{\"AC#yaJ,7o]5p]\u0006I1\r[5mIJ,g\u000eI\u0001\u0005g\u0016,G-F\u00012\u0003\u0015\u0019X-\u001a3!\u0003\u0019a\u0014N\\5u}Q\u0019A+\u0016,\u0011\u00059\u0002\u0001\"\u0002$\u0006\u0001\u0004A\u0005\"B(\u0006\u0001\u0004\tDC\u0001+Y\u0011\u0015If\u00011\u0001I\u0003%\t'oZ;nK:$8/\u0001\u0005eCR\fG+\u001f9f+\u0005a\u0006CA/a\u001b\u0005q&BA0$\u0003\u0015!\u0018\u0010]3t\u0013\t\tgL\u0001\u0005ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002IB\u0011Q-\u001b\b\u0003M\u001e\u0004\"!P\u001a\n\u0005!\u001c\u0014A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001[\u001a\u0002\u001f!\f7\u000f[3s\u00072\f7o\u001d(b[\u0016\f\u0001#[:D_2d\u0017\r^5p]\u0006;\u0018M]3\u0016\u0003=\u0004\"A\r9\n\u0005E\u001c$a\u0002\"p_2,\u0017M\\\u0001\fG>l\u0007/\u001e;f\u0011\u0006\u001c\b\u000e\u0006\u00032ifT\b\"B;\f\u0001\u00041\u0018!\u0002<bYV,\u0007C\u0001\u001ax\u0013\tA8GA\u0002B]fDQAW\u0006A\u0002qCQaT\u0006A\u0002E\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0005Qk\b\"\u0002@\r\u0001\u0004y\u0018a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004BaOA\u0001\u0017&\u0019\u00111A#\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLH#\u0002+\u0002\n\u0005-\u0001b\u0002$\u000e!\u0003\u0005\r\u0001\u0013\u0005\b\u001f6\u0001\n\u00111\u00012\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0005+\u0007!\u000b\u0019b\u000b\u0002\u0002\u0016A!\u0011qCA\u0011\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011!C;oG\",7m[3e\u0015\r\tybM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0012\u00033\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u000b+\u0007E\n\u0019\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$\u0001\u0003mC:<'BAA\u001d\u0003\u0011Q\u0017M^1\n\u0007)\f\u0019$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002BA\u0019!'a\u0011\n\u0007\u0005\u00153GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002w\u0003\u0017B\u0011\"!\u0014\u0013\u0003\u0003\u0005\r!!\u0011\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0006E\u0003\u0002V\u0005mc/\u0004\u0002\u0002X)\u0019\u0011\u0011L\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002^\u0005]#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2a\\A2\u0011!\ti\u0005FA\u0001\u0002\u00041\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\f\u0002j!I\u0011QJ\u000b\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0007KF,\u0018\r\\:\u0015\u0007=\fy\u0007\u0003\u0005\u0002NY\t\t\u00111\u0001wQM\u0001\u00111OA=\u0003w\ny(!!\u0002\u0006\u0006\u001d\u00151RAG!\rq\u0013QO\u0005\u0004\u0003oz\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003{\n!l\u0018$V\u001d\u000e{\u0006&\u001a=qeFb\u0003%\u001a=qeJb\u0003E\f\u0018/S\u0001j\u0003EU3ukJt7\u000fI1!mQj#-\u001b;!Q\u0006\u001c\b\u000e\t<bYV,\u0007e\u001c4!i\",\u0007%\u0019:hk6,g\u000e^:/A!\u000b7\u000f\u001b\u0011tK\u0016$\u0007%[:!iIr\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\r\u0015a\u0017\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6(Y\u0001\n'O]1zQE\u00124'\u000b\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u000e\u001c1eU2d\u0007M\u001c8mM*\u0004'O\u001c5qYR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0013\u000bQa\r\u00181]A\nQa\u001a:pkB\f#!a$\u0002\u0015!\f7\u000f[0gk:\u001c7/\u0001\u0005Yq\"\u000b7\u000f\u001b\u001c5!\tq\u0003dE\u0003\u0019\u0003/\u000b\u0019\u000bE\u0004\u0002\u001a\u0006}\u0005*\r+\u000e\u0005\u0005m%bAAOg\u00059!/\u001e8uS6,\u0017\u0002BAQ\u00037\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\t)+a+\u000e\u0005\u0005\u001d&\u0002BAU\u0003o\t!![8\n\u0007\u0011\u000b9\u000b\u0006\u0002\u0002\u0014\u0006AAo\\*ue&tw\r\u0006\u0002\u00020\u0005)\u0011\r\u001d9msR)A+a.\u0002:\")ai\u0007a\u0001\u0011\")qj\u0007a\u0001c\u00059QO\\1qa2LH\u0003BA`\u0003\u0017\u0004RAMAa\u0003\u000bL1!a14\u0005\u0019y\u0005\u000f^5p]B)!'a2Ic%\u0019\u0011\u0011Z\u001a\u0003\rQ+\b\u000f\\33\u0011!\ti\rHA\u0001\u0002\u0004!\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\u001b\t\u0005\u0003c\t).\u0003\u0003\u0002X\u0006M\"AB(cU\u0016\u001cG\u000f")
public class XxHash64
extends HashExpression<Object>
implements Serializable {
    private final Seq<Expression> children;
    private final long seed;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(XxHash64 x$0) {
        return XxHash64$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, XxHash64> tupled() {
        return XxHash64$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, XxHash64>> curried() {
        return XxHash64$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public long seed() {
        return this.seed;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "xxhash64";
    }

    @Override
    public String hasherClassName() {
        return XXH64.class.getName();
    }

    @Override
    public boolean isCollationAware() {
        return false;
    }

    @Override
    public long computeHash(Object value, DataType dataType, long seed) {
        return XxHash64Function$.MODULE$.hash(value, dataType, seed, this.isCollationAware(), this.legacyCollationAwareHashing());
    }

    @Override
    public XxHash64 withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public XxHash64 copy(Seq<Expression> children2, long seed) {
        return new XxHash64(children2, seed);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public long copy$default$2() {
        return this.seed();
    }

    @Override
    public String productPrefix() {
        return "XxHash64";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
            case 1: {
                return BoxesRunTime.boxToLong((long)this.seed());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XxHash64;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
            case 1: {
                return "seed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XxHash64)) return false;
        boolean bl = true;
        if (!bl) return false;
        XxHash64 xxHash64 = (XxHash64)x$1;
        if (this.seed() != xxHash64.seed()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = xxHash64.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!xxHash64.canEqual(this)) return false;
        return true;
    }

    public XxHash64(Seq<Expression> children2, long seed) {
        this.children = children2;
        this.seed = seed;
    }

    public XxHash64(Seq<Expression> arguments) {
        this(arguments, 42L);
    }
}

