/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle.objects;

import java.util.Calendar;
import java.util.TimeZone;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.PickleException;

public class OperatorAttrGetterForCalendarTz
implements IObjectConstructor {
    @Override
    public Object construct(Object[] args) {
        if (args.length != 1) {
            throw new PickleException("expected exactly one string argument for construction of AttrGetter");
        }
        if ("localize".equals(args[0])) {
            return new AttrGetterForTz();
        }
        throw new PickleException("expected 'localize' string argument for construction of AttrGetter");
    }

    static class CalendarLocalizer
    implements IObjectConstructor {
        final TimeZone tz;

        public CalendarLocalizer(TimeZone tz) {
            this.tz = tz;
        }

        @Override
        public Object construct(Object[] args) {
            if (args.length != 1 || !(args[0] instanceof Calendar)) {
                throw new PickleException("expected exactly one Calendar argument for construction of Calendar with timezone");
            }
            Calendar cal = (Calendar)args[0];
            cal.setTimeZone(this.tz);
            return cal;
        }
    }

    static class AttrGetterForTz
    implements IObjectConstructor {
        @Override
        public Object construct(Object[] args) {
            if (args.length != 1 || !(args[0] instanceof TimeZone)) {
                throw new PickleException("expected exactly one TimeZone argument for construction of CalendarLocalizer");
            }
            TimeZone tz = (TimeZone)args[0];
            return new CalendarLocalizer(tz);
        }
    }
}

