/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.util.StringJoiner;
import org.apache.spark.annotation.Private;

@Private
public class EnumUtil {
    public static <E extends Enum<E>> E parseIgnoreCase(Class<E> clz, String str) {
        Enum[] constants = (Enum[])clz.getEnumConstants();
        if (str == null) {
            return null;
        }
        for (Enum e : constants) {
            if (!e.name().equalsIgnoreCase(str)) continue;
            return (E)e;
        }
        throw new IllegalArgumentException(String.format("Illegal type='%s'. Supported type values: %s", str, EnumUtil.joinToString((Enum[])constants)));
    }

    private static <E extends Enum<E>> String joinToString(E[] enums) {
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (E e : enums) {
            stringJoiner.add(((Enum)e).name());
        }
        return stringJoiner.toString();
    }
}

