/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.ResourceNotFoundException;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.resource.ResourceID;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.util.CausedBy$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class ResourceRequestHelper$
implements Logging {
    public static final ResourceRequestHelper$ MODULE$ = new ResourceRequestHelper$();
    private static final Regex AMOUNT_AND_UNIT_REGEX;
    private static volatile int numResourceErrors;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        AMOUNT_AND_UNIT_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([0-9]+)([A-Za-z]*)"));
        numResourceErrors = 0;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Regex AMOUNT_AND_UNIT_REGEX() {
        return AMOUNT_AND_UNIT_REGEX;
    }

    private int numResourceErrors() {
        return numResourceErrors;
    }

    private void numResourceErrors_$eq(int x$1) {
        numResourceErrors = x$1;
    }

    public scala.collection.immutable.Map<String, String> getYarnResourcesAndAmounts(SparkConf sparkConf, String componentName) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(String.valueOf(componentName))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                int splitIndex = key.lastIndexOf(46);
                if (splitIndex == -1) {
                    String errorMessage = "Missing suffix for " + componentName + key + ", you must specify a suffix - " + ResourceUtils$.MODULE$.AMOUNT() + " is currently the only supported suffix.";
                    throw new IllegalArgumentException(errorMessage);
                }
                String resourceName = key.substring(0, splitIndex);
                String resourceSuffix = key.substring(splitIndex + 1);
                if (!ResourceUtils$.MODULE$.AMOUNT().equals(resourceSuffix)) {
                    String errorMessage = "Unsupported suffix: " + resourceSuffix + " in: " + componentName + key + ", only ." + ResourceUtils$.MODULE$.AMOUNT() + " is supported.";
                    throw new IllegalArgumentException(errorMessage);
                }
                return new Tuple2((Object)resourceName, (Object)value);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<String, String> getResourceNameMapping(SparkConf sparkConf) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceUtils$.MODULE$.GPU()), sparkConf.get(package$.MODULE$.YARN_GPU_DEVICE())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceUtils$.MODULE$.FPGA()), sparkConf.get(package$.MODULE$.YARN_FPGA_DEVICE()))}));
    }

    public scala.collection.immutable.Map<String, String> getYarnResourcesFromSparkResources(String confPrefix, SparkConf sparkConf) {
        return (scala.collection.immutable.Map)this.getResourceNameMapping(sparkConf).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                String yarnName = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)yarnName), (Object)sparkConf.get(new ResourceID(confPrefix, rName).amountConf(), "0"));
            }
            throw new MatchError((Object)tuple2);
        }).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ResourceRequestHelper$.$anonfun$getYarnResourcesFromSparkResources$2(x0$2)));
    }

    public void validateResources(SparkConf sparkConf) {
        Seq resourceDefinitions = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package$.MODULE$.AM_MEMORY().key(), (Object)(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX() + "memory")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), (Object)(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX() + "memory")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), (Object)(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX() + "memory")), new Tuple2((Object)package$.MODULE$.AM_MEMORY().key(), (Object)(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX() + "mb")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), (Object)(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX() + "mb")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), (Object)(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX() + "mb")), new Tuple2((Object)package$.MODULE$.AM_MEMORY().key(), (Object)(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX() + "memory-mb")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), (Object)(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX() + "memory-mb")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), (Object)(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX() + "memory-mb")), new Tuple2((Object)package$.MODULE$.AM_CORES().key(), (Object)(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX() + "cores")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES().key(), (Object)(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX() + "cores")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key(), (Object)(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX() + "cores")), new Tuple2((Object)package$.MODULE$.AM_CORES().key(), (Object)(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX() + "vcores")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES().key(), (Object)(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX() + "vcores")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key(), (Object)(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX() + "vcores")), new Tuple2((Object)package$.MODULE$.AM_CORES().key(), (Object)(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX() + "cpu-vcores")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES().key(), (Object)(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX() + "cpu-vcores")), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key(), (Object)(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX() + "cpu-vcores")), new Tuple2((Object)new ResourceID(org.apache.spark.internal.config.package$.MODULE$.SPARK_EXECUTOR_PREFIX(), "fpga").amountConf(), (Object)(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX() + sparkConf.get(package$.MODULE$.YARN_FPGA_DEVICE()))), new Tuple2((Object)new ResourceID(org.apache.spark.internal.config.package$.MODULE$.SPARK_DRIVER_PREFIX(), "fpga").amountConf(), (Object)(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX() + sparkConf.get(package$.MODULE$.YARN_FPGA_DEVICE()))), new Tuple2((Object)new ResourceID(org.apache.spark.internal.config.package$.MODULE$.SPARK_EXECUTOR_PREFIX(), "gpu").amountConf(), (Object)(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX() + sparkConf.get(package$.MODULE$.YARN_GPU_DEVICE()))), new Tuple2((Object)new ResourceID(org.apache.spark.internal.config.package$.MODULE$.SPARK_DRIVER_PREFIX(), "gpu").amountConf(), (Object)(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX() + sparkConf.get(package$.MODULE$.YARN_GPU_DEVICE())))}));
        StringBuilder errorMessage = new StringBuilder();
        resourceDefinitions.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String sparkName = (String)tuple2._1();
                String resourceRequest = (String)tuple2._2();
                String resourceRequestAmount = resourceRequest + "." + ResourceUtils$.MODULE$.AMOUNT();
                if (sparkConf.contains(resourceRequestAmount)) {
                    return errorMessage.append("Error: Do not use " + resourceRequestAmount + ", please use " + sparkName + " instead!\n");
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        if (errorMessage.nonEmpty()) {
            throw new SparkException(errorMessage.toString());
        }
    }

    public void setResourceRequests(scala.collection.immutable.Map<String, String> resources, Resource resource) {
        Predef$.MODULE$.require(resource != null, (Function0 & Serializable)() -> "Resource parameter should not be null!");
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Custom resources requested: " + resources);
        if (resources.isEmpty()) {
            return;
        }
        resources.foreach((Function1 & Serializable)x0$1 -> {
            ResourceRequestHelper$.$anonfun$setResourceRequests$3(resource, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private ResourceInformation createResourceInformation(String resourceName, long amount, String unit) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(unit))) {
            return ResourceInformation.newInstance((String)resourceName, (String)unit, (long)amount);
        }
        return ResourceInformation.newInstance((String)resourceName, (long)amount);
    }

    public static final /* synthetic */ boolean $anonfun$getYarnResourcesFromSparkResources$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String count = (String)tuple2._2();
            return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(count)) > 0L;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$setResourceRequests$3(Resource resource$1, Tuple2 x0$1) {
        Tuple2 tuple2;
        block13: {
            BoxedUnit boxedUnit;
            tuple2 = x0$1;
            if (tuple2 == null) break block13;
            String name = (String)tuple2._1();
            String rawAmount = (String)tuple2._2();
            try {
                String string;
                long amount;
                block14: {
                    Option option;
                    String string2 = rawAmount;
                    if (string2 == null || (option = MODULE$.AMOUNT_AND_UNIT_REGEX().unapplySeq((CharSequence)string2)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(2) != 0) {
                        throw new MatchError((Object)string2);
                    }
                    String amountPart = (String)((LinearSeqOps)option.get()).apply(0);
                    String unitPart = (String)((LinearSeqOps)option.get()).apply(1);
                    Tuple2 tuple22 = new Tuple2((Object)amountPart, (Object)unitPart);
                    String amountPart2 = (String)tuple22._1();
                    String unitPart2 = (String)tuple22._2();
                    amount = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(amountPart2));
                    String string3 = unitPart2;
                    switch (string3 == null ? 0 : string3.hashCode()) {
                        case 103: {
                            if (!"g".equals(string3)) break;
                            string = "G";
                            break block14;
                        }
                        case 112: {
                            if (!"p".equals(string3)) break;
                            string = "P";
                            break block14;
                        }
                        case 116: {
                            if (!"t".equals(string3)) break;
                            string = "T";
                            break block14;
                        }
                    }
                    string = unitPart2;
                }
                String unit = string;
                MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Registering resource with name: " + name + ", amount: " + amount + ", unit: " + unit);
                ResourceInformation resourceInformation = MODULE$.createResourceInformation(name, amount, unit);
                resource$1.setResourceInformation(name, resourceInformation);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Throwable e;
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof MatchError) {
                    throw new IllegalArgumentException("Resource request for '" + name + "' ('" + rawAmount + "') does not match pattern " + MODULE$.AMOUNT_AND_UNIT_REGEX() + ".");
                }
                if (throwable2 != null && !(option = CausedBy$.MODULE$.unapply(throwable2)).isEmpty() && (e = (Throwable)option.get()) instanceof IllegalArgumentException) {
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)e;
                    throw new IllegalArgumentException("Invalid request for " + name + ": " + illegalArgumentException.getMessage());
                }
                if (throwable2 instanceof ResourceNotFoundException) {
                    ResourceNotFoundException resourceNotFoundException = (ResourceNotFoundException)throwable2;
                    if (MODULE$.numResourceErrors() < 2) {
                        MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"YARN doesn't know about resource ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.RESOURCE_NAME, name)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"your resource discovery has to handle properly discovering and isolating "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"the resource! Error: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.ERROR, resourceNotFoundException.getMessage())})))));
                        MODULE$.numResourceErrors_$eq(MODULE$.numResourceErrors() + 1);
                    }
                } else {
                    throw throwable;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private ResourceRequestHelper$() {
    }
}

