/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.runtime.BoxesRunTime;

public final class NumberConverter$ {
    public static final NumberConverter$ MODULE$ = new NumberConverter$();

    private final int MAX_OUTPUT_LENGTH() {
        return 65;
    }

    private void decode(long v, int radix, byte[] value) {
        long tmpV = v;
        Arrays.fill(value, (byte)0);
        int i = value.length - 1;
        while (tmpV != 0L) {
            long q = Long.divideUnsigned(tmpV, radix);
            value[i] = (byte)(tmpV - q * (long)radix);
            tmpV = q;
            --i;
        }
    }

    private long encode(int radix, int fromPos, byte[] value, boolean ansiEnabled, QueryContext context) {
        long v = 0L;
        long bound = Long.divideUnsigned(-1 - radix, radix);
        for (int i = fromPos; i < value.length && value[i] >= 0; ++i) {
            if (v < 0L) {
                if (ansiEnabled) {
                    throw QueryExecutionErrors$.MODULE$.overflowInConvError(context);
                }
                return -1L;
            }
            if (v >= bound && Long.divideUnsigned(-1 - value[i], radix) < v) {
                if (ansiEnabled) {
                    throw QueryExecutionErrors$.MODULE$.overflowInConvError(context);
                }
                return -1L;
            }
            v = v * (long)radix + (long)value[i];
        }
        return v;
    }

    private void byte2char(int radix, int fromPos, byte[] value) {
        for (int i = fromPos; i < value.length; ++i) {
            value[i] = (byte)Character.toUpperCase(Character.forDigit(value[i], radix));
        }
    }

    private void char2byte(int radix, int fromPos, byte[] value) {
        for (int i = fromPos; i < value.length; ++i) {
            value[i] = (byte)Character.digit(value[i], radix);
            if (value[i] != -1) continue;
            return;
        }
    }

    public UTF8String convert(byte[] n, int fromBase, int toBase, boolean ansiEnabled, QueryContext context) {
        int resultStartPos;
        byte[] temp;
        block5: {
            Tuple2.mcZI.sp sp2;
            if (fromBase < 2 || fromBase > 36 || Math.abs(toBase) < 2 || Math.abs(toBase) > 36) {
                return null;
            }
            if (n.length == 0) {
                return null;
            }
            Tuple2.mcZI.sp sp3 = sp2 = n[0] == 45 ? new Tuple2.mcZI.sp(true, 1) : new Tuple2.mcZI.sp(false, 0);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            boolean negative = sp2._1$mcZ$sp();
            int first = sp2._2$mcI$sp();
            Tuple2.mcZI.sp sp4 = new Tuple2.mcZI.sp(negative, first);
            boolean negative2 = sp4._1$mcZ$sp();
            int first2 = sp4._2$mcI$sp();
            temp = new byte[Math.max(n.length, 65)];
            long v = -1L;
            System.arraycopy(n, first2, temp, temp.length - n.length + first2, n.length - first2);
            this.char2byte(fromBase, temp.length - n.length + first2, temp);
            v = this.encode(fromBase, temp.length - n.length + first2, temp, ansiEnabled, context);
            if (negative2 && toBase > 0) {
                v = v < 0L ? -1L : -v;
            }
            if (toBase < 0 && v < 0L) {
                v = -v;
                negative2 = true;
            }
            this.decode(v, Math.abs(toBase), temp);
            Object qual$1 = Predef$.MODULE$.byteArrayOps(temp);
            Function1 & Serializable x$1 = (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)NumberConverter$.$anonfun$convert$1(BoxesRunTime.unboxToByte((Object)x$2)));
            int x$22 = ArrayOps$.MODULE$.indexWhere$default$2$extension(qual$1);
            int firstNonZero = ArrayOps$.MODULE$.indexWhere$extension(qual$1, (Function1)x$1, x$22);
            int firstNonZeroPos = firstNonZero != -1 ? firstNonZero : temp.length - 1;
            this.byte2char(Math.abs(toBase), firstNonZeroPos, temp);
            resultStartPos = firstNonZeroPos;
            if (!negative2 || toBase >= 0) break block5;
            resultStartPos = firstNonZeroPos - 1;
            temp[resultStartPos] = 45;
        }
        return UTF8String.fromBytes((byte[])Arrays.copyOfRange(temp, resultStartPos, temp.length));
    }

    public byte[] toBinary(long l) {
        byte[] result = new byte[]{(byte)(l >>> 56 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return result;
    }

    public byte[] toBinary(int i) {
        byte[] result = new byte[]{(byte)(i >>> 24 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public byte[] toBinary(short s) {
        byte[] result = new byte[]{(byte)(s >>> 8 & 0xFF), (byte)(s & 0xFF)};
        return result;
    }

    public byte[] toBinary(byte s) {
        byte[] result = new byte[]{s};
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$convert$1(byte x$2) {
        return x$2 != 0;
    }

    private NumberConverter$() {
    }
}

